-- 26.09.17/AH  A2A Cessna C172 Starter ueber Throttle Quadrant
-- 				LUA Variables mit FSUIPC "List Local LUA Vars" auf Button
--				Starter-Funktion aus A2A-Dokument "A2A C172 Trainer  Variable list.pdf"
--	(L:Magnetos1Pct,percent) - starter key (range: 0 – 15: off; 16 – 37: R magneto; 38 – 63: L magneto;
-- 											64 – 85: both magnetos; 86 – 100: starter)
-- Hinweis aus Forum: You can use FSX control named MAGNETO1_SET (66400) with parameter from 0 to 4 - it works fine.
-- Lt. http://www.pilote-virtuel.com/viewtopic.php?pid=697710 muss beides (66400 und Magnetos1Pct) kombiniert werden
--
--	This script can be mapped to Starter for A2A C172 Cessna
--  without Parms: Switch Starter up; with Parm = 1 Switch Starter down
--
STARTER = ipc.readLvar("L:Magnetos1Pct")
NEWSTARTER = STARTER
-- Just for debugging
-- ipc.setdisplay(300,500,500,100)
-- ipc.lineDisplay("STARTER State on Entry:" .. STARTER,1)
-- End of debugging

--
--	Param=1 	-> Ignition Switch runterschalten
--
if ipcPARAM == 1 then
  if STARTER > 85 then
    NEWSTARTER = 64
	NEWCONTROL = 3
  elseif STARTER > 63 then
    NEWSTARTER = 38
	NEWCONTROL = 2
  elseif STARTER > 37 then
    NEWSTARTER = 16
	NEWCONTROL = 1
  else
    NEWSTARTER = 0
	NEWCONTROL = 0
  end	
--  
--	ohne Param 	-> Ignition Switch hochschalten
--
else
  if STARTER < 16 then
    NEWSTARTER = 16
	NEWCONTROL = 1
  elseif STARTER < 38 then
    NEWSTARTER = 38
	NEWCONTROL = 2
  elseif STARTER < 64 then
    NEWSTARTER = 64
	NEWCONTROL = 3
  else
    NEWSTARTER = 100
	NEWCONTROL = 4
  end	
end 
--
if NEWSTARTER ~= STARTER then
--  ipc.writeLvar("L:Eng1_StarterSwitch", NEWSTARTER)
--  ipc.lineDisplay("NEWSTARTER State:" .. NEWSTARTER .. " NEWCTL: " .. NEWCONTROL,2)
    ipc.writeLvar("L:Magnetos1Pct", NEWSTARTER)
	ipc.control(66400,NEWCONTROL)
end
-- Just for debugging
-- STARTER = ipc.readLvar("L:Eng1_StarterSwitch")
-- STARTER = ipc.readLvar("L:Magnetos1Pct")
-- ipc.lineDisplay("STARTER State on Exit:" .. STARTER,3)
-- ipc.sleep(5000)
-- End of debugging
