-- 12.03.17/AH Problem A2A Piper Lights (Dome & Red) not switchable
-- 11.05.18/AH Umstellung auf TT Statische Switch
--
--	This script can be mapped to Panel Lt & Cabin Lt Button for A2A Piper PA28
--	PARAM:
--	1=Panel Lt (Red Light)
--	2=Cabin Lt (Dome Light)
--	3=Nav+Instrument Lt (combined switch); Instr.Lt off (1) <-> dimmed (0)
--	4=Nav+Instrument Lt (combined switch); Instr.Lt dimmed (0) <-> bright (2)
-- 10=Panel Lt (Red Light) on
-- 11=Panel Lt (Red Light) off
-- 12=Cabin Lt (Dome Light) on
-- 13=Cabin Lt (Dome Light) off
-- 14=Nav+Instr Lt On
-- 15=Nav+Instr Lt Off
-- 16=Nav+Instr Lt Dimmed
-- 17=Nav+Instr Lt Bright

--
-- Red Light
--
if ipcPARAM == 10 then
  ipc.writeLvar("L:CabinRedLightSwitch", 1)
  return
elseif ipcPARAM == 11 then
  ipc.writeLvar("L:CabinRedLightSwitch", 0)
  return
elseif ipcPARAM == 12 then
  ipc.writeLvar("L:CabinLightSwitch", 1)
  return
elseif ipcPARAM == 13 then
  ipc.writeLvar("L:CabinLightSwitch", 0)
  return
-- Nav/Instr Dimmed/off/Bright  
-- Benutzt FSX User Area ab 0x66C0
-- 1 unsigned Byte in 0x66C0 für EnabState: 0=Nav/Instr disab, 1=Nav/Instr enab
-- 1 unsigned Byte in 0x66C1 für Former Position: 0=Dimmed, 1=Bright
-- LVAR NavInstrLigtSwitch: 0=Dimmed, 1=Off, 2=Bright
elseif ipcPARAM == 14 then			-- Nav/Instr on
  ipc.writeUB(0x66C0,1)				-- Write "Enable Nav/Instr" to FSX User Area
  NavDiBrState=ipc.readUB(0x66C1)		-- Read "Former Position" from FSX User Area
  if NavDiBrState == 0 then
    ipc.writeLvar("L:NavInstrLightSwitch",0) 	-- Position: Dimmed
  else	
    ipc.writeLvar("L:NavInstrLightSwitch",2)  -- Position: Bright
  end
  return
elseif ipcPARAM == 15 then  		-- Nav/Instr off
  ipc.writeUB(0x66C0,0)				-- Write "Disable Nav/Instr" to FSX User Area
  ipc.writeLvar("L:NavInstrLightSwitch",1)   -- Nav/Instr off
  return
elseif ipcPARAM == 16 then  		-- Nav/Instr bright
  ipc.writeUB(0x66C1,2)				-- Write "Former Position Bright" to FSX User Area
  TxLdEnab=ipc.readUB(0x66C0)		-- Read "Enable Nav/Instr" to FSX User Area
  if TxLdEnab == 1 then
    ipc.writeLvar("L:NavInstrLightSwitch",2)  -- Position: Bright
  end  
  return
elseif ipcPARAM == 17 then  		-- Nav/Instr dimmed  
  ipc.writeUB(0x66C1,0)				-- Write "Former Position Dimmed" to FSX User Area
  TxLdEnab=ipc.readUB(0x66C0)		-- Read "Enable Nav/Instr" to FSX User Area
  if TxLdEnab == 1 then
    ipc.writeLvar("L:NavInstrLightSwitch",0)  -- Position: Dimmed
  end  
  return
--
-- FSUIPC PARAM = 1 : Toggle Red Light
--
elseif ipcPARAM == 1 then
  REDLT = ipc.readLvar("L:CabinRedLightSwitch")
  if REDLT == 0 then
    ipc.writeLvar("L:CabinRedLightSwitch", 1)
  else
    ipc.writeLvar("L:CabinRedLightSwitch", 0)
  end
--
-- FSUIPC PARAM = 2 : Toggle Cabin Light
--
elseif ipcPARAM == 2 then
  CBNLT = ipc.readLvar("L:CabinLightSwitch")
  if CBNLT == 0 then
    ipc.writeLvar("L:CabinLightSwitch", 1)
  else
    ipc.writeLvar("L:CabinLightSwitch", 0)
  end
--  
-- FSUIPC PARAM = 3 : Toggle Nav + Instr Lights off <-> dimmed
--
elseif ipcPARAM == 3 then
  NAVLT = ipc.readLvar("L:NavInstrLightSwitch")
  if NAVLT == 1 then
    NAVLT = 0
  else
    NAVLT = 1
  end
  ipc.writeLvar("L:NavInstrLightSwitch", NAVLT)
--  
-- FSUIPC PARAM = 4 : Toggle Nav + Instr Lights dimmed <-> bright
--
elseif ipcPARAM == 4 then
  NAVLT = ipc.readLvar("L:NavInstrLightSwitch")
  if NAVLT == 0 then
    NAVLT = 2
    ipc.writeLvar("L:NavInstrLightSwitch", NAVLT)
  elseif NAVLT == 2 then
    NAVLT = 0
    ipc.writeLvar("L:NavInstrLightSwitch", NAVLT)
  end
--  
-- FSUIPC PARAM unknown
--  
else
  ipc.lineDisplay("PARAM not implemented")
  ipc.sleep(3)
end
