-- 01.10.17/AH von http://forum.aerosoft.com/index.php?/topic/125448-crj-lua-script-available/

------------------------------------------------------------
------------------------ AUTOPILOT -------------------------
------------------------------------------------------------

-- FCP FD1 (1)
-- FCP FD2 (2)
-- FCP AP ON (3)
-- FCP AP DISC (4)
-- FCP XFR (5)
-- FCP TURB (6)
-- FCP SPEED SEL (7)
-- FCP IAS/MACH (8)
-- FCP SPEED INC (9)
-- FCP SPEED DEC (10)
-- FCP APPR (11)
-- FCP BC (12)
-- FCP HDG SEL  (13)
-- FCP HDG SYNC  (14)
-- FCP HDG INC (15)
-- FCP HDG DEC (16)
-- FCP NAV (17)
-- FCP 1/2 BANK (18)
-- FCP ALT SEL (19)
-- FCP ALT ALERT CANCEL (20)
-- FCP ALT INC (21)
-- FCP ALT DEC (22)
-- FCP VS (23)
-- FCP VS WHEEL UP (24)
-- FCP VS WHEEL DOWN (25)
-- FCP CRS1 DIRECT (26)
-- FCP CRS1 INC (27)
-- FCP CRS1 DEC (28)
-- FCP CRS2 DIRECT (29)
-- FCP CRS2 INC (30)
-- FCP CRS2 DEC (31)

------------------------------------------------------------
-------------------------- EFIS ----------------------------
------------------------------------------------------------

-- EFIS BRG1 (32)
-- EFIS BRG2 (33)
-- EFIS RDR/TERR (34)
-- EFIS TFC (35)
-- EFIS MFD FORMAT INC (36)
-- EFIS MFD FORMAT DEC (37)
-- EFIS MFD RANGE INC (38)
-- EFIS MFD RANGE DEC (39)
-- EFIS NAV SOURCE X-SIDE SEL (40)
-- EFIS NAV SOURCE INC (41)
-- EFIS NAV SOURCE DEC (42)
-- EFIS REF HEIGHT DH/MDA (43)
-- EFIS REF HEIGHT SEL (44)
-- EFIS REF HEIGHT INC (45)
-- EFIS REF HEIGHT DEC (46)
-- EFIS BARO HPA/IN (47)
-- EFIS BARO STD (48)
-- EFIS BARO INC (49)
-- EFIS BARO DEC (50)

------------------------------------------------------------
-------------------------- ECAM ----------------------------
------------------------------------------------------------

-- ECAM PRI (51)
-- ECAM STAT (52)
-- ECAM ECS (53)
-- ECAM HYD (54)
-- ECAM ELEC (55)
-- ECAM FUEL (56)
-- ECAM FCTL (57)
-- ECAM A/ICE (58)
-- ECAM DOORS (59)
-- ECAM CAS (60)
-- ECAM MENU (61)
-- ECAM UP (62)
-- ECAM DOWN (63)
-- ECAM STEP (64)
-- ECAM SEL (65)

------------------------------------------------------------
----------------------- EXT LIGHTS -------------------------
------------------------------------------------------------

-- EXT LIGHTS LANDING L (66)
-- EXT LIGHTS LANDING NOSE (67)
-- EXT LIGHTS LANDING R (68)
-- EXT LIGHTS TAXI (69)
-- EXT LIGHTS NAV (70)
-- EXT LIGHTS BEACON (71)
-- EXT LIGHTS STROBE (72)
-- EXT LIGHTS LOGO (73)
-- EXT LIGHTS WING INSP (74)

------------------------------------------------------------
--------------------------- TQ -----------------------------
------------------------------------------------------------

-- TQ TO/GA (75)
-- TQ ENG1 CUTOFF(76
-- TQ ENG2 CUTOFF (77)

------------------------------------------------------------
-------------------------- YOKE ----------------------------
------------------------------------------------------------

-- YOKE AP DISC (78)

--//////////////////////////////////////////////////////////////////////////////////////////////////////////

------------------------------------------------------------
------------------------ AUTOPILOT -------------------------
------------------------------------------------------------

-- ====================== FCP FD1 (1) ======================
if ipcPARAM == 1 then
    LVarSet = "ASCRJ_FCP_FD1"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP FD2 (2) ======================
if ipcPARAM == 2 then
    LVarSet = "ASCRJ_FCP_FD2"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP AP ON (3) ======================
if ipcPARAM == 3 then
    LVarSet = "ASCRJ_FCP_AP_ENG"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP AP DISC (4) ======================
if ipcPARAM == 4 then
    LVarSet = "ASCRJ_FCP_AP_DISC"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP XFR (5) ======================
if ipcPARAM == 5 then
    LVarSet = "ASCRJ_FCP_XFR"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP TURB (6) ======================
if ipcPARAM == 6 then
    LVarSet = "ASCRJ_FCP_TURB"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP SPEED SEL (7) ======================
if ipcPARAM == 7 then
    LVarSet = "ASCRJ_FCP_SPEED"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP IAS/MACH (8) ======================
if ipcPARAM == 8 then
    LVarSet = "ASCRJ_FCP_IAS_MACH"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP SPEED INC (9) ======================
if ipcPARAM == 9 then
    LVarSet = "ASCRJ_FCP_SPEED_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP SPEED DEC (10) ======================
if ipcPARAM == 10 then
    LVarSet = "ASCRJ_FCP_SPEED_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== FCP APPR (11) ======================
if ipcPARAM == 11 then
    LVarSet = "ASCRJ_FCP_APPR"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP BC (12) ======================
if ipcPARAM == 12 then
    LVarSet = "ASCRJ_FCP_BC"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP HDG SEL  (13) ======================
if ipcPARAM == 13 then
    LVarSet = "ASCRJ_FCP_HDG"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP HDG SYNC  (14) ======================
if ipcPARAM == 14 then
    LVarSet = "ASCRJ_FCP_HDG_SYNC"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP HDG INC (15) ======================
if ipcPARAM == 15 then
    LVarSet = "ASCRJ_FCP_HDG_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP HDG DEC (16) ======================
if ipcPARAM == 16 then
    LVarSet = "ASCRJ_FCP_HDG_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== FCP NAV (17) ======================
if ipcPARAM == 17 then
    LVarSet = "ASCRJ_FCP_NAV"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP 1/2 BANK (18) ======================
if ipcPARAM == 18 then
    LVarSet = "ASCRJ_FCP_12BANK"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP ALT SEL (19) ======================
if ipcPARAM == 19 then
    LVarSet = "ASCRJ_FCP_ALT"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP ALT ALERT CANCEL (20) ======================
if ipcPARAM == 20 then
    LVarSet = "ASCRJ_FCP_ALT_CANCEL"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP ALT INC (21) ======================
if ipcPARAM == 21 then
    LVarSet = "ASCRJ_FCP_ALT_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP ALT DEC (22) ======================
if ipcPARAM == 22 then
    LVarSet = "ASCRJ_FCP_ALT_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== FCP VS (23) ======================
if ipcPARAM == 23 then
    LVarSet = "ASCRJ_FCP_VS"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP VS WHEEL UP (24) ======================
if ipcPARAM == 24 then
    LVarSet = "ASCRJ_FCP_WHEEL_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP VS WHEEL DOWN (25) ======================
if ipcPARAM == 25 then
    LVarSet = "ASCRJ_FCP_WHEEL_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== FCP CRS1 DIRECT (26) ======================
if ipcPARAM == 26 then
    LVarSet = "ASCRJ_FCP_CRS1_DIRECT"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP CRS1 INC (27) ======================
if ipcPARAM == 27 then
    LVarSet = "ASCRJ_FCP_CRS1_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP CRS1 DEC (28) ======================
if ipcPARAM == 28 then
    LVarSet = "ASCRJ_FCP_CRS1_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== FCP CRS2 DIRECT (29) ======================
if ipcPARAM == 29 then
    LVarSet = "ASCRJ_FCP_CRS2_DIRECT"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP CRS2 INC (30) ======================
if ipcPARAM == 30 then
    LVarSet = "ASCRJ_FCP_CRS2_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== FCP CRS2 DEC (31) ======================
if ipcPARAM == 31 then
    LVarSet = "ASCRJ_FCP_CRS2_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

------------------------------------------------------------
-------------------------- EFIS ----------------------------
------------------------------------------------------------

-- ====================== EFIS BRG1 (32) ======================
if ipcPARAM == 32 then
    LVarSet = "ASCRJ_LSP_BRG1"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS BRG2 (33) ======================
if ipcPARAM == 33 then
    LVarSet = "ASCRJ_LSP_BRG2"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS RDR/TERR (34) ======================
if ipcPARAM == 34 then
    LVarSet = "ASCRJ_LSP_RDR"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS TFC (35) ======================
if ipcPARAM == 35 then
    LVarSet = "ASCRJ_LSP_TERR"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS MFD FORMAT INC (36) ======================
if ipcPARAM == 36 then
    LVarSet = "ASCRJ_LSP_FORMAT_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS MFD FORMAT DEC (37) ======================
if ipcPARAM == 37 then
    LVarSet = "ASCRJ_LSP_FORMAT_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== EFIS MFD RANGE INC (38) ======================
if ipcPARAM == 38 then
    LVarSet = "ASCRJ_LSP_RANGE_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS MFD RANGE DEC (39) ======================
if ipcPARAM == 39 then
    LVarSet = "ASCRJ_LSP_RANGE_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== EFIS NAV SOURCE X-SIDE SEL (40) ======================
if ipcPARAM == 40 then
    LVarSet = "ASCRJ_LSP_NAV_SOURCE_XSIDE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS NAV SOURCE INC (41) ======================
if ipcPARAM == 41 then
    LVarSet = "ASCRJ_LSP_NAV_SOURCE_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS NAV SOURCE DEC (42) ======================
if ipcPARAM == 42 then
    LVarSet = "ASCRJ_LSP_NAV_SOURCE_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== EFIS REF HEIGHT DH/MDA (43) ======================
if ipcPARAM == 43 then

	if ipc.readLvar("ASCRJ_LSP_HEIGHT_MODE") == 0 then
	ipc.writeLvar("ASCRJ_LSP_HEIGHT_MODE", 1)
	else
	ipc.writeLvar("ASCRJ_LSP_HEIGHT_MODE", 0)
	end

end

-- ====================== EFIS REF HEIGHT SEL (44) ======================
if ipcPARAM == 44 then
    LVarSet = "ASCRJ_LSP_HEIGHT_SET"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS REF HEIGHT INC (45) ======================
if ipcPARAM == 45 then
    LVarSet = "ASCRJ_LSP_HEIGHT_SEL_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS REF HEIGHT DEC (46) ======================
if ipcPARAM == 46 then
    LVarSet = "ASCRJ_LSP_HEIGHT_SEL_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

-- ====================== EFIS BARO HPA/IN (47) ======================
if ipcPARAM == 47 then
    LVarSet = "ASCRJ_LSP_HPA_IN"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS BARO STD (48) ======================
if ipcPARAM == 48 then
    LVarSet = "ASCRJ_LSP_BARO_STD"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS BARO INC (49) ======================
if ipcPARAM == 49 then
    LVarSet = "ASCRJ_LSP_BARO_CHANGE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== EFIS BARO DEC (50) ======================
if ipcPARAM == 50 then
    LVarSet = "ASCRJ_LSP_BARO_CHANGE"
    ipc.writeLvar(LVarSet, -1)
end

------------------------------------------------------------
-------------------------- ECAM ----------------------------
------------------------------------------------------------

-- ====================== ECAM PRI (51) ======================
if ipcPARAM == 51 then
    LVarSet = "ASCRJ_ECAM_PRI"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM STAT (52) ======================
if ipcPARAM == 52 then
    LVarSet = "ASCRJ_ECAM_STAT"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM ECS (53) ======================
if ipcPARAM == 53 then
    LVarSet = "ASCRJ_ECAM_ECS"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM HYD (54) ======================
if ipcPARAM == 54 then
    LVarSet = "ASCRJ_ECAM_HYD"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM ELEC (55) ======================
if ipcPARAM == 55 then
    LVarSet = "ASCRJ_ECAM_ELEC"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM FUEL (56) ======================
if ipcPARAM == 56 then
    LVarSet = "ASCRJ_ECAM_FUEL"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM FCTL (57) ======================
if ipcPARAM == 57 then
    LVarSet = "ASCRJ_ECAM_FCTL"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM A/ICE (58) ======================
if ipcPARAM == 58 then
    LVarSet = "ASCRJ_ECAM_AICE"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM DOORS (59) ======================
if ipcPARAM == 59 then
    LVarSet = "ASCRJ_ECAM_DOORS"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM CAS (60) ======================
if ipcPARAM == 60 then
    LVarSet = "ASCRJ_ECAM_CAS"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM MENU (61) ======================
if ipcPARAM == 61 then
    LVarSet = "ASCRJ_ECAM_MENU"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM UP (62) ======================
if ipcPARAM == 62 then
    LVarSet = "ASCRJ_ECAM_UP"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM DOWN (63) ======================
if ipcPARAM == 63 then
    LVarSet = "ASCRJ_ECAM_DOWN"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM STEP (64) ======================
if ipcPARAM == 64 then
    LVarSet = "ASCRJ_ECAM_STEP"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== ECAM SEL (65) ======================
if ipcPARAM == 65 then
    LVarSet = "ASCRJ_ECAM_SEL"
    ipc.writeLvar(LVarSet, 1)
end

------------------------------------------------------------
----------------------- EXT LIGHTS -------------------------
------------------------------------------------------------

-- ====================== EXT LIGHTS LANDING L (66) ======================
if ipcPARAM == 66 then
    
	if ipc.readLvar("ASCRJ_OVHD_LDG_LEFT") == 0 then
	ipc.writeLvar("ASCRJ_OVHD_LDG_LEFT", 1)
	else
	ipc.writeLvar("ASCRJ_OVHD_LDG_LEFT", 0)
	end
	
end

-- ====================== EXT LIGHTS LANDING NOSE (67) ======================
if ipcPARAM == 67 then

    if ipc.readLvar("ASCRJ_OVHD_LDG_NOSE") == 0 then
	ipc.writeLvar("ASCRJ_OVHD_LDG_NOSE", 1)
	else
	ipc.writeLvar("ASCRJ_OVHD_LDG_NOSE", 0)
	end
	
end

-- ====================== EXT LIGHTS LANDING R (68) ======================
if ipcPARAM == 68 then
    
	if ipc.readLvar("ASCRJ_OVHD_LDG_RIGHT") == 0 then
	ipc.writeLvar("ASCRJ_OVHD_LDG_RIGHT", 1)
	else
	ipc.writeLvar("ASCRJ_OVHD_LDG_RIGHT", 0)
	end
	
end

-- ====================== EXT LIGHTS TAXI (69) ======================
if ipcPARAM == 69 then
   
	if ipc.readLvar("ASCRJ_OVHD_TAXI") == 0 then
	ipc.writeLvar("ASCRJ_OVHD_TAXI", 1)
	else
	ipc.writeLvar("ASCRJ_OVHD_TAXI", 0)
	end
	
end

-- ====================== EXT LIGHTS NAV (70) ======================
if ipcPARAM == 70 then
    
	if ipc.readLvar("ASCRJ_EXTL_NAV") == 0 then
	ipc.writeLvar("ASCRJ_EXTL_NAV", 1)
	else
	ipc.writeLvar("ASCRJ_EXTL_NAV", 0)
	end
	
end

-- ====================== EXT LIGHTS BEACON (71) ======================
if ipcPARAM == 71 then

	if ipc.readLvar("ASCRJ_EXTL_BEACON") == 0 then
	ipc.writeLvar("ASCRJ_EXTL_BEACON", 1)
	else
	ipc.writeLvar("ASCRJ_EXTL_BEACON", 0)
	end
	
end

-- ====================== EXT LIGHTS STROBE (72) ======================
if ipcPARAM == 72 then

	if ipc.readLvar("ASCRJ_EXTL_STROBE") == 0 then
	ipc.writeLvar("ASCRJ_EXTL_STROBE", 1)
	else
	ipc.writeLvar("ASCRJ_EXTL_STROBE", 0)
	end
	
end

-- ====================== EXT LIGHTS LOGO (73) ======================
if ipcPARAM == 73 then

	if ipc.readLvar("ASCRJ_EXTL_LOGO") == 0 then
	ipc.writeLvar("ASCRJ_EXTL_LOGO", 1)
	else
	ipc.writeLvar("ASCRJ_EXTL_LOGO", 0)
	end
	
end

-- ====================== EXT LIGHTS WING INSP (74) ======================
if ipcPARAM == 74 then

	if ipc.readLvar("ASCRJ_EXTL_WING") == 0 then
	ipc.writeLvar("ASCRJ_EXTL_WING", 1)
	else
	ipc.writeLvar("ASCRJ_EXTL_WING", 0)
	end
	
end

------------------------------------------------------------
--------------------------- TQ -----------------------------
------------------------------------------------------------

-- ====================== TQ TO/GA (75) ======================
if ipcPARAM == 75 then
    LVarSet = "ASCRJ_TQ_TOGA_1"
    ipc.writeLvar(LVarSet, 1)
end

-- ====================== TQ ENG1 CUTOFF(76) ======================
if ipcPARAM == 76 then

	if ipc.readLvar("ASCRJ_TQ_CUTOFF_1") == 0 then
	ipc.writeLvar("ASCRJ_TQ_CUTOFF_1", 1)
	else
	ipc.writeLvar("ASCRJ_TQ_CUTOFF_1", 0)
	end
	
end

-- ====================== TQ ENG2 CUTOFF (77) ======================
if ipcPARAM == 77 then

	if ipc.readLvar("ASCRJ_TQ_CUTOFF_2") == 0 then
	ipc.writeLvar("ASCRJ_TQ_CUTOFF_2", 1)
	else
	ipc.writeLvar("ASCRJ_TQ_CUTOFF_2", 0)
	end
	
end

------------------------------------------------------------
-------------------------- YOKE ----------------------------
------------------------------------------------------------

-- ====================== YOKE AP DISC (78) ======================
if ipcPARAM == 78 then
    LVarSet = "ASCRJ_YOKEC_APDISC"
    ipc.writeLvar(LVarSet, 1)
end

