-- 17.05.20/AH  Flysimware Falcon 50 Autopilot
--
-- Parm 1/2 : Altitude Selection
-- Parm 3	: Yaw Damper toggle on/off 
-- Parm 4	: AP XFR toggle (Switch AP NAV1 <-> NAV2)
--

--
--
function SwitchClick(fswsound)
   wavname="SND" .. fswsound .. ".wav"
   sound.path("FSW")
   SNDREF=sound.play(wavname)
--   ipc.display("Playing " .. wavname)
end  


--
-- Parm 1/2 : Altitude Selection
--
if ipcPARAM == 1 then
    actAlt = ipc.readLvar("ALERTER_CUSTOM")
    if actAlt < 99000 then
		ipc.sleep(50)
		actAlt = actAlt + 500
		ipc.writeLvar("ALERTER_CUSTOM", actAlt)
    end
elseif ipcPARAM == 2 then
    actAlt = ipc.readLvar("ALERTER_CUSTOM")
    if actAlt >= 1000 then
		ipc.sleep(50)
		actAlt = actAlt - 500
		ipc.writeLvar("ALERTER_CUSTOM", actAlt)
    end
--	
-- Parm 3	: Yaw Damper toggle on/off (if autopilot=on: yaw damper stays on - mechanical coupled)
--
elseif ipcPARAM == 3 then
--	YAWDMPR=ipc.readUD(0x0808)		-- Yaw Damper Status 0=off, 1=on
	AUTOPIL=ipc.readUD(0x07BC)		-- Autopilot Status 0=off, 1=on
	if AUTOPIL ~=1 then
		ipc.control(66792)			-- Toggle yaw damper, ("The 2016 List of FSX and P3D Controls": G1000 MFD SOFTKEY1 = 66792)
		SwitchClick(71)
	end
--	
-- Parm 4	: AP XFR toggle  (AP NAV1<->NAV2)
--
elseif ipcPARAM == 4 then
	APXFR=ipc.readLvar("AP_SW_XFR")	-- AP NAV 0=NAV1, 1=NAV2
	if APXFR ~=1 then
		ipc.writeLvar("AP_SW_XFR",1)	-- AP NAV1->NAV2
	else
		ipc.writeLvar("AP_SW_XFR",0)	-- AP NAV2->NAV1
	end
else
  -- Message in Sim
  ipc.display("Falcon50_AP: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end		
--