-- 24.06.20/AH  Flysimware Falcon 50 Brake
-- Falcon 50 hat zweistufige Parkbremse:
-- Parm 0	: SW_BRAKE Stufe 0 (Parking Brake offen)
-- Parm 1	: SW_BRAKE Stufe 1 (normale Bremse)
-- Parm 2	: SW_BRAKE Stufe 2 (Emergency Brake)
-- Falcon 50 hat zweistufige Spoiler=Speed-Brake
-- Parm 3	: LEVER_SPOILER Stufe 0 (eingefahren)
-- Parm 4	: LEVER_SPOILER Stufe 1 (halb ausgefahren)
-- Parm 5	: LEVER_SPOILER Stufe 2 (voll ausgefahren)
-- Standby-Pump
-- Parm 6	: Standby Pump Switch up (OFF - ON - AUTO)
-- Parm 7	: Standby Pump Switch down

--
--
function SwitchClick(fswsound)
   wavname="SND" .. fswsound .. ".wav"
   sound.path("FSW")
   SNDREF=sound.play(wavname)
--   ipc.display("Playing " .. wavname)
end  

--
-- Read necessary LVARs (if too much have to be read, move them under the according sections)
SWBRAKE=ipc.readLvar("L:SW_BRAKE")
LVSPOIL=ipc.readLvar("L:LEVER_SPOILER")
STBYPMP=ipc.readLvar("L:STBY_PUMP")

--
-- Parm 0	: Parking Brake off
if ipcPARAM == 0 then
	if SWBRAKE ~= 0 then
		ipc.writeUW(0x0BC8,0)		-- Parking Brake 0=off
		ipc.writeLvar("L:SW_BRAKE",0)
		SwitchClick(10)
	end
--
-- Parm 1	: Parking Brake normal
elseif ipcPARAM == 1 then
	if SWBRAKE ~= 1 then
		ipc.writeUW(0x0BC8,32767)		-- Parking Brake 32767=on
		ipc.writeLvar("L:SW_BRAKE",1)
		SwitchClick(10)
	end
--
-- Parm 2	: Parking Brake emergency
elseif ipcPARAM == 2 then
	if SWBRAKE ~= 2 then
		ipc.writeUW(0x0BC8,32767)		-- Parking Brake 32767=on
		ipc.writeLvar("L:SW_BRAKE",2)
		SwitchClick(10)
	end
--
-- Parm 3	: Spoiler retracted
elseif ipcPARAM == 3 then
	if LVSPOIL ~= 0 then
		ipc.writeUW(0x0BD0,0)			-- Spoiler 0=retracted
		ipc.writeLvar("L:LEVER_SPOILER",0)
	end
--
-- Parm 4	: Spoiler half engaged
elseif ipcPARAM == 4 then
	if LVSPOIL ~= 1 then
		ipc.writeUW(0x0BD0,8193)			-- Spoiler 1=half
		ipc.writeLvar("L:LEVER_SPOILER",1)
	end
--
-- Parm 5	: Spoiler
elseif ipcPARAM == 5 then
	if LVSPOIL ~= 2 then
		ipc.writeUW(0x0BD0,16384)			-- Spoiler 2=full
		ipc.writeLvar("L:LEVER_SPOILER",2)
	end
--
-- Parm 6	: Hydraulic Standby-Pump upward
elseif ipcPARAM == 6 then
	if STBYPMP < 2 then
		STBYPMP = STBYPMP + 1
		ipc.writeLvar("L:STBY_PUMP",STBYPMP)
		ipc.writeLvar("L:XMLSND61",1)		-- Switch sound
	end
--
-- Parm 7	: Hydraulic Standby-Pump upward
elseif ipcPARAM == 7 then
	if STBYPMP > 0 then
		STBYPMP = STBYPMP - 1
		ipc.writeLvar("L:STBY_PUMP",STBYPMP)
		ipc.writeLvar("L:XMLSND61",1)		-- Switch sound
	end
---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("Falcon50_Brake: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end	
