-- 16.07.20/AH  Flysimware Falcon 50 Engine Switches
-- 
-- Parm 1/2 : Engine Switch Up/Dn
--
-- The sound names relate to sounds in the P3D subfolder "Sounds\FSW" (Flysimware),
--

--
-- Parm 1/2 : Engine switches toggle
--			Special behaviour: the switches will be moved to the highest/lowest switch position
--								of any of the switches, so all switches are in the same position
--								after toggling upward or downward
--								Deviating positions for individual switches must be set manually by mouse.
--
if ipcPARAM == 1 then
-- Read switch positions: -1=motor start, 0=grd start -1=air start
    swipos1=ipc.readLvar("SW_GRD_START1")
    swipos2=ipc.readLvar("SW_GRD_START2")
    swipos3=ipc.readLvar("SW_GRD_START3")
	if swipos1 < 1 then				-- switch below "air start" ?
	  swipos1=swipos1+1
      ipc.writeLvar("SW_GRD_START1",swipos1)
 	  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
-- if another switch is on a higher position, move this switch to the same position (means: one higher)
	  if ( swipos1 < swipos2 ) or ( swipos1 < swipos3 ) then -- another switch higher ?
        ipc.sleep(150)
	    swipos1=swipos1+1
        ipc.writeLvar("SW_GRD_START1",swipos1)
 	    ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	  end	
      ipc.sleep(300)
    end	  
	if swipos2 < 1 then				-- switch below "air start" ?
	  swipos2=swipos2+1
      ipc.writeLvar("SW_GRD_START2",swipos2)
 	  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
-- if another switch is on a higher position, move this switch to the same position (means: one higher)
	  if ( swipos2 < swipos1 ) or ( swipos2 < swipos3 ) then -- another switch higher ?
        ipc.sleep(150)
	    swipos2=swipos2+1
        ipc.writeLvar("SW_GRD_START2",swipos2)
 	    ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	  end	
      ipc.sleep(300)
    end	  
	if swipos3 < 1 then				-- switch below "air start" ?
	  swipos3=swipos3+1
      ipc.writeLvar("SW_GRD_START3",swipos3)
 	  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
-- if another switch is on a higher position, move this switch to the same position (means: one more higher)
	  if ( swipos3 < swipos1 ) or ( swipos3 < swipos2 ) then -- another switch higher ?
        ipc.sleep(150)
	    swipos3=swipos3+1
        ipc.writeLvar("SW_GRD_START3",swipos3)
 	    ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	  end	
      ipc.sleep(300)
    end	  
elseif ipcPARAM == 2 then
-- Read switch positions: -1=motor start, 0=grd start -1=air start
    swipos1=ipc.readLvar("SW_GRD_START1")
    swipos2=ipc.readLvar("SW_GRD_START2")
    swipos3=ipc.readLvar("SW_GRD_START3")
	if swipos1 > -1 then				-- switch above "motor start" ?
	  swipos1=swipos1-1
      ipc.writeLvar("SW_GRD_START1",swipos1)
 	  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
-- if another switch is on a lower position, move this switch to the same position (means: one more lower)
	  if ( swipos1 > swipos2 ) or ( swipos1 > swipos3 ) then -- another switch lower ?
        ipc.sleep(150)
	    swipos1=swipos1-1
        ipc.writeLvar("SW_GRD_START1",swipos1)
 	    ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	  end	
      ipc.sleep(300)
    end	  
	if swipos2 > -1 then				-- switch above "motor start" ?
	  swipos2=swipos2-1
      ipc.writeLvar("SW_GRD_START2",swipos2)
 	  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
-- if another switch is on a lower position, move this switch to the same position (means: one more lower)
	  if ( swipos2 > swipos1 ) or ( swipos2 > swipos2 ) then -- another switch lower ?
        ipc.sleep(150)
	    swipos2=swipos2-1
        ipc.writeLvar("SW_GRD_START2",swipos2)
 	    ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	  end	
      ipc.sleep(300)
    end	  
	if swipos3 > -1 then				-- switch above "motor start" ?
	  swipos3=swipos3-1
      ipc.writeLvar("SW_GRD_START3",swipos3)
 	  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
-- if another switch is on a lower position, move this switch to the same position (means: one more lower)
	  if ( swipos3 > swipos1 ) or ( swipos3 > swipos2 ) then -- another switch lower ?
        ipc.sleep(150)
	    swipos3=swipos3-1
        ipc.writeLvar("SW_GRD_START3",swipos3)
 	    ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	  end	
      ipc.sleep(300)
    end	  

---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("Falcon50_Switch: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end	
  


-- DEBUG --
-- for i=1,30 do
-- 	SM1=ipc.readLvar("STARTER1_MODE")
--	SM2=ipc.readLvar("STARTER2_MODE")
--	SM3=ipc.readLvar("STARTER3_MODE")
--	SA1=ipc.readLvar("STARTER1_ACTIVE")
--	SA2=ipc.readLvar("STARTER2_ACTIVE")
--	SA3=ipc.readLvar("STARTER3_ACTIVE")
--	ipc.display(i..": SM1:"..SM1.." SM2:"..SM2.." SM3:"..SM3..": SA1:"..SA1.." SA2:"..SA2.." SA3:"..SA3.."    ")
--	ipc.sleep(1000)
-- end	
