-- 17.05.20/AH  Flysimware Falcon 50 Lamps
-- 24.05.20/AH nach https://www.avsim.com/forums/topic/575698-switch-off-taxi-lights-from-fsuipc-lua/?tab=comments#comment-4242115
--				Taxilights funktionieren. Function SwitchClick ersetzt durch XMLSND...
-- 
-- Parm 1    : Anticollision Red
-- Parm 2    : Anticollision Off
-- Parm 3    : Anticollision All=Beacon+Strobe on
-- Parm 4    : Anticollision Red=Beacon on
-- Logik Parm 1...4:
-- Tact&Toggle Switch 1 schaltet Off/Red
-- Tact&Toggle Switch 2 schaltet Red/All
-- Switch-Sound nur, wenn Schalter tatsächlich bewegt wird
-- Zustand Switch 2 wird in FSX User-Area festgehalten
--
-- Parm 5/6  : Landing Lights ON/OFF (Stellung "Pulse" wird nicht abgedeckt)
-- Parm 7/8  : Taxi Lights ON/OFF
-- Parm 9/10 : Recog (at the front of the wings)
-- Parm 11/12: Instrument Lights
-- Parm 13/14 Passenger Cabin (Logo)
--

--
-- 24.05.20 ersetzt durch XMLSND<nummer>
--			diese LVARs werden wohl bei der Initialisierung des Aircraft geladen
--			die Sounds befinden sich in FWS unterhalb C:\Games\Lockheed Martin\Prepar3D v4\Sound\
--			sound.path bezieht sich bei Relativen Pfaden immer auf C:\Games\Lockheed Martin\Prepar3D v4\Sound\
-- Function SwitchClick für die Schaltersounds
-- Aufruf mit Sound-Nummer (die Sounds heissen alle SND<nummer>.wav) :
--		 	  SwitchClick(68)
-- SND61.wav = Fuelcomputer-Schalter (CMPTR)
-- SND68.wav = Landing/Taxi Lights Schalter
-- SND69.wav = Batterie/Generator-Schalter
-- SND70.wav = Große Schalter am Overhead (z.B. Booster)
-- SND72.wav = Taster (z.B. APU, Batteriekontrolltaster)
--
function SwitchClick(fswsound)
   wavname="SND" .. fswsound .. ".wav"
   sound.path("FSW")
   SNDREF=sound.play(wavname)
   ipc.display("Playing " .. wavname)
end  


--	
-- Parm 1   : Switch 1 = Anticollision On (Red=Beacon oder All=Beacon+Strobe)
--
if ipcPARAM == 1 then
-- L:SW_BEACON_LIGHTS=2 0x0D0C=18=16+2 -> ALL
-- L:SW_BEACON_LIGHTS=1 0x0D0C=2 -> RED
-- L:SW_BEACON_LIGHTS=0 0x0D0C=0 -> OFF
--
-- Benutzt FSX User Area ab 0x66C0
-- 1 unsigned Byte in 0x66C0 für Schalterstellung Switch 2 Red/All: 2=Red, 0x12=ALL
	swi2pos=ipc.readUB(0x66C0)			-- Read Position Switch 2 from FSX User Area
	if swi2pos == 0 then				-- Switch 2 not moved ?
	  swi2pos = 0x02					-- then assume Switch 2 Position = RED
	end
	
--
	ANTICOLL=ipc.readUW(0x0D0C)		-- Bit mask for Lights
    bcnstrb=logic.And(ANTICOLL, 0x12)		-- Bits 1 (Bcn) und 4 (Strb) maskieren
    if bcnstrb ~= swi2pos then				-- Bits not equal to actual position of Switch 2 ?
      dummy=ipc.clearbitsUW(0x0D0C, 0x12)		-- Clear Beacon+Strobe
	  dummy=ipc.setbitsUW(0x0D0C, swi2pos)		-- Set Beacon/Strobe to actual Position of Swi 2
	  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
    end
--
-- Parm 2   :  Switch 1 = Anticollision Off
--
elseif ipcPARAM == 2 then
	ANTICOLL=ipc.readUW(0x0D0C)		-- Bit mask for Lights
    bcnstrb=logic.And(ANTICOLL, 0x12)		-- Bits 1 (Bcn) und 4 (Strb) maskieren
    if bcnstrb ~= 0 then	
      dummy=ipc.clearbitsUW(0x0D0C, 0x12)		-- Clear Beacon+Strobe
      ipc.writeLvar("L:XMLSND70",1)					-- switch sound
    end
--	
-- Parm 3   :  Switch 2 = Setze/Schalte Anticollision ALL (Beacon+Strobe)
--
elseif ipcPARAM == 3 then
-- Benutzt FSX User Area ab 0x66C0
-- 1 unsigned Byte in 0x66C0 für Schalterstellung Switch 2 Red/All: 2=Red, 0x12=ALL
	swi2all=0x12					-- Switch 2 ALL
	ipc.writeUB(0x66C0,swi2all)		-- Write Switch 2 ALL to FSX User Area
--
	ANTICOLL=ipc.readUW(0x0D0C)				-- Bit mask for Lights
    bcnstrb=logic.And(ANTICOLL, swi2all)		-- Bits 1 (Bcn) und 4 (Strb) maskieren
	if bcnstrb ~= 0	then						-- if one or both of the Bits set (Swi 1 not off)
	  if bcnstrb ~= swi2all then				-- if both bits not set
        strobebit=logic.And(ANTICOLL, 0x010)	-- Bit 4 (Strb) maskieren
	    if  logic.And(strobebit, 0x10) < 1 then	-- Anti-Collision-Switch RED ?
	      dummy=ipc.setbitsUW(0x0D0C, 0x10)		-- Set Anti-Collision-Switch ALL
		  ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	    end	
	  end	
	end  
	
--	
-- Parm 4   :  Switch 2 = Setze/Schalte Anticollision RED (Beacon only)
--
elseif ipcPARAM == 4 then
-- Benutzt FSX User Area ab 0x66C0
-- 1 unsigned Byte in 0x66C0 für Schalterstellung Switch 2 Red/All: 2=Red, 0x12=ALL
    swi2red=0x02
	ipc.writeUB(0x66C0,swi2red)		-- Write Switch 2 RED to FSX User Area
--	
	ANTICOLL=ipc.readUW(0x0D0C)		-- Bit mask for Lights
    bcnstrb=logic.And(ANTICOLL, 0x012)		-- Bits 1 (Bcn) und 4 (Strb) maskieren
	if bcnstrb ~= 0	then						-- if one or both of the Bits set (Swi 1 not off)
      strobebit=logic.And(ANTICOLL, 0x010)		-- Bit 4 (Strb) maskieren
	  if  logic.And(strobebit, 0x10) > 0 then	-- Anti-Collision-Switch ALL (Strobe set) ?
	    dummy=ipc.clearbitsUW(0x0D0C, 0x10)		-- Set Anti-Collision-Switch RED
	    ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	  end	
	end  

--	
-- Parm 5/6   :  Landing Lights ON/OFF (Stellung "Pulse" wird nicht abgedeckt)
--
elseif ipcPARAM == 5 then
	landlt=ipc.readLvar("LANDING_LIGHTS")
	if landlt < 1 then
	  ipc.writeLvar("LANDING_LIGHTS",2)
      ipc.writeLvar("L:XMLSND68",1)					-- switch sound
	  ipc.sleep(200)
	end  
	LndLt=ipc.readUW(0x0D0C)					-- Bit mask for Instr-Lights
    LndBits=logic.And(LndLt, 0x0004)			-- Bit 2 (Landing Lt.) maskieren
    if LndBits ~= 0x0004 then	
		ipc.control(65751)						-- if Bit 2 off, toggle landing lights
	end
elseif ipcPARAM == 6 then
	landlt=ipc.readLvar("LANDING_LIGHTS")
	if landlt > 0 then
	  ipc.writeLvar("LANDING_LIGHTS",0)
      ipc.writeLvar("L:XMLSND68",1)					-- switch sound
	  ipc.sleep(200)
	end  
	LndLt=ipc.readUW(0x0D0C)					-- Bit mask for Instr-Lights
    LndBits=logic.And(LndLt, 0x0004)			-- Bit 2 (Landing Lt.) maskieren
    if LndBits ~= 0 then	
		ipc.control(65751)						-- if Bit 2 on, toggle landing lights
	end
--	
-- Parm 7/8   :  Taxi Lights ON/OFF
--
elseif ipcPARAM == 7 then
-- Check F50 taxi light switch
-- Attention: switch is memory for taxi lt position while gear retracted !
-- F50 special: to activate the taxi light, do not toggle taxi light, but set SW_TAXI_LIGHTS to 1
--				The F50 checks this variable and sets the taxi light according to the gear position
--				The F50 unsets/sets the taxi light automatically while retracting/extracting gear
--				Any own setting (control 66240 or 0X0D0C bit 8) disturbs this mechanism
--				So, toggling has to be done only if switching off the taxi light,
--				else the taxi light shines on the cockpit roof if gear is retracted !
	taxi_lt_switch=ipc.readLvar("SW_TAXI_LIGHTS")		-- get current taxi light switch value:0=off, 1=on
	if taxi_lt_switch ~= 1 then
		ipc.writeLvar("SW_TAXI_LIGHTS",1)			-- Switch to position "lights on"
		ipc.writeLvar("L:XMLSND68",1)			-- switch sound
		ipc.sleep(200)
	end
-------- following section must not used !   ------------	
-- P3D control 66240 : Toggle Taxi Light
--	GearPos=ipc.readUW(0x0BEC)					-- Nose-Gear Position 0=Full Up, 16384=Full Down
--	TaxiLt=ipc.readUW(0x0D0C)					-- Bit mask for Instr-Lights
--  TaxiBits=logic.And(TaxiLt,8)				-- Bit 3 (Taxi Lt.) maskieren
--    if GearPos > 12000 and TaxiBits ~= 8 then	-- TaxiLt, but only if Gear down !
--	    ipc.control(66240)								-- Toggle Taxi Lights
--		ipc.sleep(200)
--	end
-----------------------------------------------------------
elseif ipcPARAM == 8 then
-- Check taxi light switch
	taxi_lt_switch=ipc.readLvar("SW_TAXI_LIGHTS")		-- get current taxi light switch value:0=off, 1=on
	if taxi_lt_switch ~= 0 then
		ipc.writeLvar("SW_TAXI_LIGHTS",0)			-- Switch to position "lights off"
		ipc.writeLvar("L:XMLSND68",1)			-- switch sound
		ipc.sleep(200)
	end
-- 0x0D0C=x08 -> Taxi Lights (switching off has to be done by the script)
	TaxiLt=ipc.readUW(0x0D0C)					-- Bit mask for Instr-Lights
    TaxiBits=logic.And(TaxiLt, 0x0008)			-- Bit 3 (Taxi Lt.) maskieren
    if TaxiBits ~= 0 then	
	    ipc.control(66240)						-- if bit 3 on, Toggle Taxi Lights
		ipc.sleep(200)
	end
--
-- Parm 9/10 Recog (at the front of the wings)
--
elseif ipcPARAM == 9 then
	RecogLt=ipc.readLvar("L:SW_RECOG_LIGHTS")	-- LVAR for Recog-Light
    if RecogLt ~= 1 then	
		ipc.writeLvar("L:SW_RECOG_LIGHTS",1)	-- Set Recog-Light (Wings), sound not included
		ipc.writeLvar("L:XMLSND70",1)			-- switch sound
    end
	
elseif ipcPARAM == 10 then
	RecogLt=ipc.readLvar("L:SW_RECOG_LIGHTS")	-- LVAR for Recog-Light
    if RecogLt ~= 0 then	
		ipc.writeLvar("L:SW_RECOG_LIGHTS",0)	-- Cler Recog-Light (Wings), sound not included
		ipc.writeLvar("L:XMLSND70",1)			-- switch sound
    end
--		
-- Parm 11/12: Instrument Lights
--
elseif ipcPARAM == 11 then
-- 0x0D0C=x20 -> Instrument Lights
	InstrLt=ipc.readUW(0x0D0C)					-- Bit mask for Instr-Lights
    InstrBits=logic.And(InstrLt, 0x20)			-- Bit 5 (Instr.) maskieren
    if InstrBits ~= 0x20 then	
		dummy=ipc.setbitsUW(0x0D0C, 0x20)		-- Set Instr-Light
		ipc.writeLvar("L:XMLSND70",1)			-- switch sound
	end
elseif ipcPARAM == 12 then
	InstrLt=ipc.readUW(0x0D0C)					-- Bit mask for Instr-Lights
    InstrBits=logic.And(InstrLt, 0x20)			-- Bit 5 (Instr.) maskieren
    if InstrBits ~= 0 then	
		dummy=ipc.clearbitsUW(0x0D0C, 0x20)		-- Set Instr-Light
		ipc.writeLvar("L:XMLSND70",1)			-- switch sound
	end
--
-- Parm 13/14 Passenger Cabin (Logo)
--
elseif ipcPARAM == 13 then
-- 0x0D0C=x140=x100 -> Logo (Passenger-Cabin)
	LogoLt=ipc.readUW(0x0D0C)					-- Bit mask for Logo-Lights
    LogoBit=logic.And(LogoLt, 0x200)			-- Bit 8 (Logo) maskieren
    if LogoBit ~= 0x200 then	
		dummy=ipc.setbitsUW(0x0D0C, 0x200)		-- Set Logo-Light (Passenger Cabin) incl. sound
	end
	
elseif ipcPARAM == 14 then
	LogoLt=ipc.readUW(0x0D0C)					-- Bit mask for Logo-Lights
    LogoBit=logic.And(LogoLt, 0x200)		-- Bits 6 (Recog) und 8 (Logo) maskieren
    if LogoBit ~= 0 then	
		dummy=ipc.clearbitsUW(0x0D0C, 0x200)	-- Clear Logo-Light (Passenger Cabin) incl. sound
	end	
		
---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("Falcon50_Lamps: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end