-- 17.05.20/AH  Flysimware Falcon 50 diverse Switche
-- 
-- Parm 1/2 : Battery (T&T)  1=on, 2=off
-- Parm 3: Booster 2 middle (CH TQ)  Toggle on/off
-- Parm 4: Booster 1 left + 3 right (CH TQ)  Toggle off, wenn beide auf 1 sind, sonst beide on
-- Parm 5: APU on (komplett mit Bleed-Air)
-- Parm 6: APU off
-- Parm 7: Generator 1...3 on
-- Parm 8: Generator 1...3 off
-- Parm 9: Fuel-Computer (CMPTR) 1...3 on
-- Parm 10: Fuel-Computer (CMPTR) 1...3 off
-- Parm 11,12,13: Shutoff-Tasten Engine an Throttle 1..3, Sound inkludiert
-- Parm 14,15,16: Starter-Button Engine 1..3 (ohne HOLD)
-- Parm 17: Switch Both Inverter on
-- Parm 18: Switch Both Inverter on
-- Parm 19: XFER Pump 2 toggle
-- Parm 20: XFER Pump 1+3 toggle
-- Parm 21: Toggle FUEL_SEL (Anzeige-Umschaltung Wing/Feeder Tanks)
-- Parm 22: Toggle ADF<->VOR Pilot
--
--
-- Originalsounds werden aus dem P3D-Subfolder Sounds\FSW (Flysimware) abgespielt,
-- Dazu wird der sound.path auf "FSW" (unterhalb des P3D Default-Soundfolders) gesetzt
--

--
-- 24.05.20 ersetzt durch XMLSND<nummer>
--			diese LVARs werden wohl bei der Initialisierung des Aircraft geladen
--			die Sounds befinden sich in FWS unterhalb C:\Games\Lockheed Martin\Prepar3D v4\Sound\
--			sound.path bezieht sich bei Relativen Pfaden immer auf C:\Games\Lockheed Martin\Prepar3D v4\Sound\
-- Function SwitchClick für die Schaltersounds
-- Aufruf mit Sound-Nummer (die Sounds heissen alle SND<nummer>.wav) :
--		 	  SwitchClick(68)
-- SND61.wav = Fuelcomputer-Schalter (CMPTR)
-- SND68.wav = Landing/Taxi Lights Schalter
-- SND69.wav = Batterie/Generator-Schalter
-- SND70.wav = Große Schalter am Overhead (z.B. Booster)
-- SND72.wav = Taster (z.B. APU, Batteriekontrolltaster)
--
function SwitchClick(fswsound)
  wavname="SND" .. fswsound .. ".wav"
  sound.path("FSW")
  SNDREF=sound.play(wavname)
--  ipc.display("Playing " .. wavname)
end  

--
-- Parm 1/2 : Battery (T&T)  1=on, 2=off
--
if ipcPARAM == 1 then
	BATLEFT=ipc.readLvar("SW_BATT1")
	if BATLEFT < 1 then
	  ipc.writeLvar("SW_BATT1",1)	-- Battery 1 on
	  ipc.writeLvar("L:XMLSND69",1)					-- switch sound
	end  
	BATRIGHT=ipc.readLvar("SW_BATT2")
	if BATRIGHT < 1 then
	  ipc.sleep(300) 
	  ipc.writeLvar("SW_BATT2",1)	-- Battery 2 on
	  ipc.writeLvar("L:XMLSND69",1)					-- switch sound
	end  
elseif ipcPARAM == 2 then
    ipc.writeLvar("SW_BATT1",0)
	ipc.writeLvar("L:XMLSND69",1)					-- switch sound
	ipc.sleep(300) 
    ipc.writeLvar("SW_BATT2",0)
	ipc.writeLvar("L:XMLSND69",1)					-- switch sound
--
-- Parm 3: Booster 2 middle (CH TQ)  Toggle on/off
--
elseif ipcPARAM == 3 then
    BOOSTERMID=ipc.readLvar("SW_BOOSTER2")
	if BOOSTERMID < 1 then
	    ipc.writeLvar("SW_BOOSTER2",1)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	else
		ipc.writeLvar("SW_BOOSTER2",0)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	end
--
-- Parm 4: Booster 1 left + 3 right (CH TQ)  Toggle off, wenn beide auf 1 sind, sonst beide on
--
elseif ipcPARAM == 4 then
    BOOSTERLE=ipc.readLvar("SW_BOOSTER1")
    BOOSTERRI=ipc.readLvar("SW_BOOSTER3")
	if BOOSTERLE > 0 and BOOSTERRI > 0 then
	    ipc.writeLvar("SW_BOOSTER1",0)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
		ipc.sleep(300) 
	    ipc.writeLvar("SW_BOOSTER3",0)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	else
		if BOOSTERLE < 1 then
			ipc.writeLvar("SW_BOOSTER1",1)
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
		end	
		if BOOSTERRI < 1 then
			if BOOSTERLE < 1 then
				ipc.sleep(300) 
			end	
			ipc.writeLvar("SW_BOOSTER3",1)
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
		end
	end
--
-- Parm 5: APU on (komplett mit Bleed-Air)
--
elseif ipcPARAM == 5 then
-- 	 4858137       L:APU_BLEED_MODE = 0.000000
--   4858137       L:APU_MASTER_MODE = 1.000000
--   4858137       L:APU_STOP_MODE = 0.000000
--   4858137       L:APU_LOP_MODE = 0.000000
--   4858137       L:APU_GEN_MODE = 1.000000
--   4858137       L:APU_START_MODE = 0.000000
--		
	APUMASTERMODE=ipc.readLvar("APU_MASTER_MODE")
    APUSTARTMODE=ipc.readLvar("APU_START_MODE")
    APUSTOPMODE=ipc.readLvar("APU_STOP_MODE")
-- Darf nur anlaufen, wenn MASTER aus, START aus, STOP aus	
	if APUMASTERMODE < 1 and APUSTARTMODE < 1 and APUSTOPMODE < 1 then
	  ipc.writeLvar("APU_MASTER_MODE",1)
 	  ipc.writeLvar("L:XMLSND72",1)					-- switch sound
	  ipc.sleep(500) 
	  ipc.writeLvar("APU_GEN_MODE",1)
 	  ipc.writeLvar("L:XMLSND72",1)					-- switch sound
	  ipc.sleep(500) 
	  ipc.writeLvar("APU_START_MODE",1)
 	  ipc.writeLvar("L:XMLSND72",1)					-- switch sound
	  ipc.sleep(500) 
	  for i=1,90 do				-- max. 90 Sekunden prüfen, ob APU laeuft
	    APUSTARTMODE=ipc.readLvar("APU_START_MODE")
		if APUSTARTMODE < 1 then		-- Startmode wieder auf 0 (d.h. APU laeuft) ?
			ipc.writeLvar("APU_BLEED_MODE",1)	-- Dann APU Bleed ein
			ipc.writeLvar("L:XMLSND72",1)					-- switch sound
			break		-- Leave for loop
		end	
  	    ipc.sleep(1000) 
	  end	
	end
--
-- Parm 6: APU off
--
elseif ipcPARAM == 6 then
	APUMASTERMODE=ipc.readLvar("APU_MASTER_MODE")
    APUSTARTMODE=ipc.readLvar("APU_START_MODE")
    APUSTOPMODE=ipc.readLvar("APU_STOP_MODE")
-- Darf nur anlaufen, wenn MASTER ein, START aus, STOP aus	
	if APUMASTERMODE > 0 and APUSTARTMODE < 1 and APUSTOPMODE < 1 then
	  ipc.writeLvar("APU_STOP_MODE",1)
 	  ipc.writeLvar("L:XMLSND72",1)					-- switch sound
	  ipc.sleep(500) 
	  for i=1,90 do				-- max. 90 Sekunden prüfen, ob APU aus
	    APUSTOPMODE=ipc.readLvar("APU_STOP_MODE")
		if APUSTOPMODE < 1 then		-- Startmode wieder auf 0 ?
			ipc.writeLvar("APU_MASTER_MODE",0)	-- Master schaltet auch Bleed-Air aus, falls on.
			ipc.writeLvar("L:XMLSND72",1)					-- switch sound
			break		-- Leave for loop
		end	
  	    ipc.sleep(1000) 
	  end	
	end
--
-- Parm 7: Generator 1...3 on
-- (Default-Belegung Offset X'3101' 01/00 schaltet alle drei auf einmal, aber ohne Klicksound)
--
elseif ipcPARAM == 7 then
	ipc.writeSB(0x3b78, 1)	
	ipc.sleep(200)
	ipc.writeSB(0x3ab8, 1)	
	ipc.sleep(400)				-- etwas länger, da Switch 3 auf rechter Seite
	ipc.writeSB(0x39f8, 1)	
--
-- Parm 8: Generator 1...3 off
--
elseif ipcPARAM == 8 then
	ipc.writeSB(0x3b78, 0)	
	ipc.sleep(200)
	ipc.writeSB(0x3ab8, 0)	
	ipc.sleep(400)				-- etwas länger, da Switch 3 auf rechter Seite
	ipc.writeSB(0x39f8, 0)	
--
-- Parm 9: Fuel-Computer (CMPTR) 1...3 on
--
elseif ipcPARAM == 9 then
	ipc.writeLvar("SW_CMPTR1",1)
	ipc.writeLvar("L:XMLSND61",1)					-- switch sound
	ipc.sleep(500)
	ipc.writeLvar("SW_CMPTR2",1)
	ipc.writeLvar("L:XMLSND61",1)					-- switch sound
	ipc.sleep(500)
	ipc.writeLvar("SW_CMPTR3",1)
	ipc.writeLvar("L:XMLSND61",1)					-- switch sound
--
-- Parm 10: Fuel-Computer (CMPTR) 1...3 off
--
elseif ipcPARAM == 10 then
	ipc.writeLvar("SW_CMPTR1",0)
	ipc.writeLvar("L:XMLSND61",1)					-- switch sound
	ipc.sleep(500)
	ipc.writeLvar("SW_CMPTR2",0)
	ipc.writeLvar("L:XMLSND61",1)					-- switch sound
	ipc.sleep(500)
	ipc.writeLvar("SW_CMPTR3",0)
	ipc.writeLvar("L:XMLSND61",1)					-- switch sound
--
-- Parm 11,12,13: Toggle Shutoff-Tasten Engine an Throttle 1..3, Sound inkludiert
--
elseif ipcPARAM == 11 then
	SHUTLFT=ipc.readLvar("FALCON_SHUTOFF1")
	if SHUTLFT < 1 then
	  ipc.writeLvar("STARTER1_MODE",0)
	  ipc.writeLvar("STARTER1_ACTIVE",0)
	  ipc.writeLvar("FALCON_SHUTOFF1",1)
	else  
	  ipc.writeLvar("FALCON_SHUTOFF1",0)
	end  
elseif ipcPARAM == 12 then
	SHUTMID=ipc.readLvar("FALCON_SHUTOFF2")
	if SHUTMID < 1 then
  	  ipc.writeLvar("STARTER2_MODE",0)
	  ipc.writeLvar("STARTER2_ACTIVE",0)
	  ipc.writeLvar("FALCON_SHUTOFF2",1)
	else  
	  ipc.writeLvar("FALCON_SHUTOFF2",0)
	end  
	  
elseif ipcPARAM == 13 then
	SHUTRGT=ipc.readLvar("FALCON_SHUTOFF3")
	if SHUTRGT < 1 then
	  ipc.writeLvar("STARTER3_MODE",0)
	  ipc.writeLvar("STARTER3_ACTIVE",0)
	  ipc.writeLvar("FALCON_SHUTOFF3",1)
	else  
	  ipc.writeLvar("FALCON_SHUTOFF3",0)
	end  
--
-- Parm 14,15,16: Starter-Button Engine 1..3 (ohne HOLD)
--
elseif ipcPARAM == 14 then
	SM1=ipc.readLvar("STARTER1_MODE")
	SA1=ipc.readLvar("STARTER1_ACTIVE")
	if SM1 < 1 and SA1 < 1 then
		ipc.writeLvar("SW_STARTER1",1)		-- Starter-Button drücken
		ipc.sleep(500)
		ipc.writeLvar("STARTER1_MODE",1)	-- Engine-Start triggern
		ipc.sleep(1500)
		ipc.writeLvar("SW_STARTER1",0)		-- Starter-Button release
	end	
elseif ipcPARAM == 15 then
	SM2=ipc.readLvar("STARTER2_MODE")
	SA2=ipc.readLvar("STARTER2_ACTIVE")
	if SM2 < 1 and SA2 < 1 then
		ipc.writeLvar("SW_STARTER2",1)		-- Starter-Button drücken
		ipc.sleep(500)
		ipc.writeLvar("STARTER2_MODE",1)	-- Engine-Start triggern
		ipc.sleep(1500)
		ipc.writeLvar("SW_STARTER2",0)		-- Starter-Button release
	end	
elseif ipcPARAM == 16 then
	SM3=ipc.readLvar("STARTER3_MODE")
	SA3=ipc.readLvar("STARTER3_ACTIVE")
	if SM3 < 1 and SA3 < 1 then
		ipc.writeLvar("SW_STARTER3",1)		-- Starter-Button drücken
		ipc.sleep(500)
		ipc.writeLvar("STARTER3_MODE",1)	-- Engine-Start triggern
		ipc.sleep(1500)
		ipc.writeLvar("SW_STARTER3",0)		-- Starter-Button release
	end	
--
-- Parm 17: Switch Both Inverter on
--
elseif ipcPARAM == 17 then
  InvState=ipc.readLvar("L:SW_AC1") -- get left Inverter state
  if InvState < 1 then
    InvState=1					-- left Inverter on
    ipc.writeLvar("L:SW_AC1",InvState)   -- Set left Inverter
	ipc.writeLvar("L:XMLSND70",1)					-- switch sound
  end	
  ipc.sleep(300)
  InvState=ipc.readLvar("L:SW_AC2") -- get right Inverter state
  if InvState < 1 then
    InvState=1					-- right Inverter on
    ipc.writeLvar("L:SW_AC2",InvState)   -- Set right Inverter
	ipc.writeLvar("L:XMLSND70",1)					-- switch sound
  end	
--
-- Parm 18: Switch Both Inverter on
--
elseif ipcPARAM == 18 then  
  InvState=ipc.readLvar("L:SW_AC1") -- get left Inverter state
  if InvState ~= 0 then
    InvState=0					-- left Inverter off
    ipc.writeLvar("L:SW_AC1",InvState)   -- Set left Inverter
	ipc.writeLvar("L:XMLSND70",1)					-- switch sound
  end	
  ipc.sleep(300)
  InvState=ipc.readLvar("L:SW_AC2") -- get right Inverter state
  if InvState ~= 0 then
    InvState=0					-- right Inverter off
    ipc.writeLvar("L:SW_AC2",InvState)   -- Set left Inverter
	ipc.writeLvar("L:XMLSND70",1)					-- switch sound
  end	  
--
-- Parm 19: XFER Pump 2 toggle
--
elseif ipcPARAM == 19 then  
	XFRPumpMid=ipc.readLvar("L:SW_XFRPUMP2_SWITCH") -- get mid XFER pump state
	if XFRPumpMid ~= 1 then
		ipc.writeLvar("L:SW_XFRPUMP2_SWITCH",1)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	else	
		ipc.writeLvar("L:SW_XFRPUMP2_SWITCH",0)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	end
--
-- Parm 20: XFER Pump 1+3 toggle
--
elseif ipcPARAM == 20 then  
	XFRPumpLft=ipc.readLvar("L:SW_XFRPUMP1_SWITCH") -- get left XFER pump state
	XFRPumpRgt=ipc.readLvar("L:SW_XFRPUMP3_SWITCH") -- get right XFER pump state
	if XFRPumpLft > 0 and XFRPumpRgt > 0 then
	    ipc.writeLvar("L:SW_XFRPUMP1_SWITCH",0)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
		ipc.sleep(300) 
	    ipc.writeLvar("L:SW_XFRPUMP3_SWITCH",0)
		ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	else
		if XFRPumpLft < 1 then
			ipc.writeLvar("L:SW_XFRPUMP1_SWITCH",1)
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
		end	
		if XFRPumpRgt < 1 then
			if XFRPumpLft < 1 then
				ipc.sleep(300) 
			end	
			ipc.writeLvar("L:SW_XFRPUMP3_SWITCH",1)
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
		end
	end
--
-- Parm 21: Fuel Display Selector
--
elseif ipcPARAM == 21 then  
	FUELSEL=ipc.readLvar("L:FUEL_SEL") 			-- get state of fuel display selector switch
	if FUELSEL < 1 then
			ipc.writeLvar("L:FUEL_SEL",1)		-- Fuel selector 1=up : display shows wing tanks
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	else
			ipc.writeLvar("L:FUEL_SEL",0)		-- Fuel selector 0=down : display shows feeder tanks
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	end
--
-- Parm 22: Toggle Pilot's ADF<->VOR switch (bearing pointer in Pilot HSI)	
--
elseif ipcPARAM == 22 then  
	ADFVOR=ipc.readLvar("L:ADFVOR_PILOT") 			-- get state of ADF-VOR switch
	if ADFVOR < 1 then
			ipc.writeLvar("L:ADFVOR_PILOT",1)		-- ADF-VOR 1=ADF : Pilot bearing pointer shows direction of NDB
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	else
			ipc.writeLvar("L:ADFVOR_PILOT",0)		-- ADF-VOR 0=ADF : Pilot bearing pointer shows VOR radial
			ipc.writeLvar("L:XMLSND70",1)					-- switch sound
	end
	
---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("Falcon50_Switch: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end	
  


-- DEBUG --
-- for i=1,30 do
-- 	SM1=ipc.readLvar("STARTER1_MODE")
--	SM2=ipc.readLvar("STARTER2_MODE")
--	SM3=ipc.readLvar("STARTER3_MODE")
--	SA1=ipc.readLvar("STARTER1_ACTIVE")
--	SA2=ipc.readLvar("STARTER2_ACTIVE")
--	SA3=ipc.readLvar("STARTER3_ACTIVE")
--	ipc.display(i..": SM1:"..SM1.." SM2:"..SM2.." SM3:"..SM3..": SA1:"..SA1.." SA2:"..SA2.." SA3:"..SA3.."    ")
--	ipc.sleep(1000)
-- end	
