-- 27.06.21/AH  IRIS Raptor F22 (Prepar3D V4 Default Aircraft) Engine/Brake
-- Parm  1/2  : Battery on/off 
-- Parm  3/4  : APU on/off 
-- Parm  5/6  : Switch Right Engine on (auf hintere Throttle-Zone legen, 6 when entered, 5 when exited)  
-- Parm  7/8  : Switch Left Engine on (auf hintere Throttle-Zone legen, 8 when entered, 7 when exited)  
-- Parm  9/10 : Parking Brake Switch Up/Dn
-- Parm 11/12 : Generator Left on/off
-- Parm 13/14 : Generator Right on/off
-- Parm 15/16 : Fuel Tanks Ext/All
-- ------------------------------------------------------------------------------------------------------
-- 
-- Parm  1/2  : Battery on/off
--
if ipcPARAM == 1 then
  F22SWBATT=ipc.readLvar("F22_SW_BATT")
  if F22SWBATT ~= 1 then
    ipc.writeLvar("L:F22_SW_BATT",1)	-- Battery on
  end	
elseif ipcPARAM == 2 then
  F22SWBATT=ipc.readLvar("F22_SW_BATT")
  if F22SWBATT ~= 0 then
    ipc.writeLvar("L:F22_SW_BATT",0)	-- Battery off
  end	
--  
-- Parm  3/4  : APU on/off 
--				Hinweis: APU-Switch ist immer auf 1 (ARM),
--				die Positionen START (2) und STOP (0) sind nur temporär
--
elseif ipcPARAM == 3 then
  APURUN=ipc.readLvar("APU_RUN")		-- nur einschalten, wenn auch aus (APU_RUN=1)
  if APURUN == 0 then
    ipc.writeLvar("F22_SW_APU",2)		-- APU START
    ipc.sleep(500)						-- Wait a little bit
    ipc.writeLvar("F22_SW_APU",1)		-- APU ARM
  end	
elseif ipcPARAM == 4 then
  APUONINIT=ipc.readLvar("APU_ON_INIT")	-- nur ausschalten, wenn auch ein (APU_ON_INIT=1 bzw. größer 0)
  if APUONINIT > 0 then
    ipc.writeLvar("F22_SW_APU",0)		-- APU OFF
    ipc.sleep(500)						-- Wait a little bit
    ipc.writeLvar("F22_SW_APU",1)		-- APU ARM
  end
--
-- Parm  5/6  : Switch Right Engine on (auf hintere Throttle-Zone legen, 6 when entered, 5 when exited)  
--
elseif ipcPARAM == 5 then
  ENGRIGHT=ipc.readLvar("F22_SW_RENG")	-- nur einschalten, wenn auch aus (F22_SW_RENG=0)
  if ENGRIGHT ~= 1 then
    ipc.writeLvar("F22_SW_RENG",1)		-- Start right engine
  end	
elseif ipcPARAM == 6 then
  ENGRIGHT=ipc.readLvar("F22_SW_RENG")	-- nur ausschalten, wenn auch ein (F22_SW_RENG=1)
  if ENGRIGHT ~= 0 then
    ipc.writeLvar("F22_SW_RENG",0)		-- Shutdown right engine
  end	
--
-- Parm  7/8  : Switch Left Engine on (auf hintere Throttle-Zone legen, 8 when entered, 7 when exited)  
--
elseif ipcPARAM == 7 then
  ENGLEFT=ipc.readLvar("F22_SW_LENG")	-- nur einschalten, wenn auch aus (F22_SW_LENG=0)
  if ENGLEFT ~= 1 then
    ipc.writeLvar("F22_SW_LENG",1)		-- Start right engine
  end	
elseif ipcPARAM == 8 then
  ENGLEFT=ipc.readLvar("F22_SW_LENG")	-- nur ausschalten, wenn auch ein (F22_SW_LENG=1)
  if ENGLEFT ~= 0 then
    ipc.writeLvar("F22_SW_LENG",0)		-- Shutdown right engine
  end	
            
--
-- Parm  9/10 : Parking Brake Switch Up/Dn
--
elseif ipcPARAM == 9 then
  PARKBRK=ipc.readLvar("F22_SW_PARK_BRAKE")
  if PARKBRK < 2 then
    PARKBRK=PARKBRK+1							-- increment park brake switch position
    ipc.writeLvar("F22_SW_PARK_BRAKE",PARKBRK)	-- Parkingbrake switch nach oben
    ipc.writeLvar("SWITCH_CLICK_ON",1)			-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 10 then
  PARKBRK=ipc.readLvar("F22_SW_PARK_BRAKE")
  if PARKBRK > 0 then
    PARKBRK=PARKBRK-1							-- decrement park brake switch position
    ipc.writeLvar("F22_SW_PARK_BRAKE",PARKBRK)	-- Parkingbrake switch nach oben
    ipc.writeLvar("SWITCH_CLICK_OFF",1)			-- Schaltersound off/n.unten
  end	
--
-- Parm 11/12 : Generator Left on/off
--
elseif ipcPARAM == 11 then
  GENLFT=ipc.readLvar("F22_SW_LGEN")	-- nur einschalten, wenn auch aus
  if GENLFT ~= 1 then
    ipc.writeLvar("F22_SW_LGEN",1)		-- Left generator on
    ipc.writeLvar("SWITCH_CLICK_ON",1)	-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 12 then
  GENLFT=ipc.readLvar("F22_SW_LGEN")	-- nur ausschalten, wenn auch ein
  if GENLFT ~= 0 then
    ipc.writeLvar("F22_SW_LGEN",0)		-- Left generator off
    ipc.writeLvar("SWITCH_CLICK_OFF",1)	--- Schaltersound off/n.unten
  end	
--
-- Parm 13/14 : Generator Right on/off
--
elseif ipcPARAM == 13 then
  GENRGT=ipc.readLvar("F22_SW_RGEN")	-- nur einschalten, wenn auch aus
  if GENRGT ~= 1 then
    ipc.writeLvar("F22_SW_RGEN",1)		-- Left generator on
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end
elseif ipcPARAM == 14 then
  GENRGT=ipc.readLvar("F22_SW_RGEN")	-- nur ausschalten, wenn auch ein
  if GENRGT ~= 0 then
    ipc.writeLvar("F22_SW_RGEN",0)		-- Left generator off
    ipc.writeLvar("SWITCH_CLICK_OFF",1)	-- Schaltersound off/n.unten
  end	
--
-- Parm 15/16 : Fuel Tanks Ext/All
--
elseif ipcPARAM == 15 then
  TANKMODE=ipc.readLvar("F22_SW_FTANKS")	-- Status Fuel Tanks (0=EXT, 1=ALL/int)
  if TANKMODE ~= 1 then
    ipc.writeLvar("F22_SW_FTANKS",1)		-- Tanks ALL (internal)
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end
elseif ipcPARAM == 16 then
  TANKMODE=ipc.readLvar("F22_SW_FTANKS")	-- Status Fuel Tanks (0=EXT, 1=ALL/int)
  if TANKMODE ~= 0 then
    ipc.writeLvar("F22_SW_FTANKS",0)		-- Tanks EXT
    ipc.writeLvar("SWITCH_CLICK_OFF",1)		-- Schaltersound off/n.unten
  end
			

---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("IRIS F22 Engine: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end	
  

