-- 20.07.21/AH  IRIS Raptor F22 (Prepar3D V4 Default Aircraft) Instruments
-- Parm  1/2  : RSMFD CRS
-- Parm  3/4  : Exterior lights OFF/POS+ANTICOLL/ANTICOLL
-- Parm  5/6  : Landing/Taxi lights TAXI/OFF/LAND
-- Parm  7/8  : Oxygen Mixture 100%/Auto
-- Parm  9/10 : Oxygen mode normal/bypass
-- Parm 11/12 : OBOGS on/off
-- Parm 13/14 : AAR door open/close (Luftbetankung)
-- Parm 15/16 : Canopy open/close (für Switch, nicht toggle)
-- Parm 17/18 : Turn Formation Lt Knob Left/Right
-- Parm 19/20 : Knob Console Light full right/left
-- Parm 21/22 : Knob Flood Light full right/left
-- Parm 23/24 : Knob MFD Light full right/left
-- Parm 25/26 : Knob Inst Light full right/left
--
------------------------------------------------------------------------------------------------------
-- 
-- Parm  1/2  : Change Course (CRS) up/dn by 1, if EHSI shown on right, center or left SMFD panel
--				SMFD Buttons numbered from 1 (lower bar leftmost) to 15 (left bar bottom) counterclockwise 
--
if ipcPARAM == 1 then
  NAVSIG=ipc.readUB(0x0C4D)			-- Offset 0x0C4D, Bit 3 set: "NAV1 no signal"
  NAVSIGBIT=logic.And(NAVSIG,8)		-- Mask Bit 8
  if NAVSIGBIT == 0 then	 		-- only if NAV1 has signal ("no signal" bit is not set)
-- check if EHSI page (#2) selected in any SMFD panel
    RSMFDPG=ipc.readLvar("RSMFD_PAGE")
    LSMFDPG=ipc.readLvar("LSMFD_PAGE")
    CSMFDPG=ipc.readLvar("CSMFD_PAGE")
    if RSMFDPG == 2 then 					-- RSMFD is EHSI
      keypress="RSMFD_BTN_8"
    elseif CSMFDPG == 2 then 				-- CSMFD is EHSI
      keypress="CSMFD_BTN_8"
    elseif LSMFDPG == 2 then 				-- LSMFD is EHSI
      keypress="LSMFD_BTN_8"
    else
      keypress=""							-- no EHSI on any of the three SMFD panels
    end
--  
    if keypress ~= "" then
      ipc.writeLvar(keypress,1)			-- press xSMFD third button from top on the right bar
      ipc.writeLvar("KNOB_CLICK",1)		-- Schaltersound on/n.oben
    end	
  end	

elseif ipcPARAM == 2 then
  NAVSIG=ipc.readUB(0x0C4D)			-- Offset 0x0C4D, Bit 3 set: "NAV1 no signal"
  NAVSIGBIT=logic.And(NAVSIG,8)		-- Mask Bit 8
  if NAVSIGBIT == 0 then	 		-- only if NAV1 has signal ("no signal" bit is not set)
-- check if EHSI page (#2) selected in any SMFD panel
    RSMFDPG=ipc.readLvar("RSMFD_PAGE")
    LSMFDPG=ipc.readLvar("LSMFD_PAGE")
    CSMFDPG=ipc.readLvar("CSMFD_PAGE")
    if RSMFDPG == 2 then 					-- RSMFD is EHSI
      keypress="RSMFD_BTN_9"
    elseif CSMFDPG == 2 then 				-- CSMFD is EHSI
      keypress="CSMFD_BTN_9"
    elseif LSMFDPG == 2 then 				-- LSMFD is EHSI
      keypress="LSMFD_BTN_9"
    else
      keypress=""							-- no EHSI on any of the three SMFD panels
    end
--  
    if keypress ~= "" then
      ipc.writeLvar(keypress,1)			-- press xSMFD second button from top on the right bar
      ipc.writeLvar("KNOB_CLICK",1)		-- Schaltersound on/n.oben
    end	
  end	
-- 
-- Parm  3/4  : Change Course (CRS) up/dn by 15 degrees, if EHSI shown on right, center or left SMFD panel
--				SMFD Buttons numbered from 1 (lower bar leftmost) to 15 (left bar bottom) counterclockwise 
--
elseif ipcPARAM == 3 then
  NAVSIG=ipc.readUB(0x0C4D)			-- Offset 0x0C4D, Bit 3 set: "NAV1 no signal"
  NAVSIGBIT=logic.And(NAVSIG,8)		-- Mask Bit 8
  if NAVSIGBIT == 0 then	 		-- only if NAV1 has signal ("no signal" bit is not set)
-- check if EHSI page (#2) selected in any SMFD panel
    RSMFDPG=ipc.readLvar("RSMFD_PAGE")
    LSMFDPG=ipc.readLvar("LSMFD_PAGE")
    CSMFDPG=ipc.readLvar("CSMFD_PAGE")
    if RSMFDPG == 2 then 					-- RSMFD is EHSI
      keypress="RSMFD_BTN_8"
    elseif CSMFDPG == 2 then 				-- CSMFD is EHSI
      keypress="CSMFD_BTN_8"
    elseif LSMFDPG == 2 then 				-- LSMFD is EHSI
      keypress="LSMFD_BTN_8"
    else
      keypress=""							-- no EHSI on any of the three SMFD panels
    end
--  
    if keypress ~= "" then
      for i=1, 15 do
        ipc.writeLvar(keypress,1)			-- press xSMFD third button times from top on the right bar
	    ipc.writeLvar("KNOB_CLICK",1)		-- Schaltersound on/n.oben
	    ipc.sleep(50)
	  end  
    end	
  end	
--
elseif ipcPARAM == 4 then
  NAVSIG=ipc.readUB(0x0C4D)			-- Offset 0x0C4D, Bit 3 set: "NAV1 no signal"
  NAVSIGBIT=logic.And(NAVSIG,8)		-- Mask Bit 8
  if NAVSIGBIT == 0 then	 		-- only if NAV1 has signal ("no signal" bit is not set)
-- check if EHSI page (#2) selected in any SMFD panel
    RSMFDPG=ipc.readLvar("RSMFD_PAGE")
    LSMFDPG=ipc.readLvar("LSMFD_PAGE")
    CSMFDPG=ipc.readLvar("CSMFD_PAGE")
    if RSMFDPG == 2 then 					-- RSMFD is EHSI
      keypress="RSMFD_BTN_9"
    elseif CSMFDPG == 2 then 				-- CSMFD is EHSI
      keypress="CSMFD_BTN_9"
    elseif LSMFDPG == 2 then 				-- LSMFD is EHSI
      keypress="LSMFD_BTN_9"
    else
      keypress=""							-- no EHSI on any of the three SMFD panels
    end
--  
    if keypress ~= "" then
      for i=1, 15 do
        ipc.writeLvar(keypress,1)			-- press xSMFD second button from top on the right bar
	    ipc.writeLvar("KNOB_CLICK",1)		-- Schaltersound on/n.oben
	    ipc.sleep(50)
	  end
    end	
  end	
---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("IRIS F22 Lights: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end	
  

