-- 29.06.21/AH  IRIS Raptor F22 (Prepar3D V4 Default Aircraft) Light
-- Parm  1/2  : Interior lights NVG/NIGHT/DAY
-- Parm  3/4  : Exterior lights OFF/POS+ANTICOLL/ANTICOLL
-- Parm  5/6  : Landing/Taxi lights TAXI/OFF/LAND
-- Parm  7/8  : Oxygen Mixture 100%/Auto
-- Parm  9/10 : Oxygen mode normal/bypass
-- Parm 11/12 : OBOGS on/off
-- Parm 13/14 : AAR door open/close (Luftbetankung)
-- Parm 15/16 : Canopy open/close (für Switch, nicht toggle)
-- Parm 17/18 : Turn Formation Lt Knob Left/Right
-- Parm 19/20 : Knob Console Light full right/left
-- Parm 21/22 : Knob Flood Light full right/left
-- Parm 23/24 : Knob MFD Light full right/left
-- Parm 25/26 : Knob Inst Light full right/left
--
------------------------------------------------------------------------------------------------------
-- 
-- Parm  1/2  : Interior lights NVG/NIGHT/DAY
--
if ipcPARAM == 1 then
  LTMODEI=ipc.readLvar("F22_SW_LT_MODE")
  if LTMODEI < 2 then
    LTMODEI=LTMODEI+1						-- increment Int.Lt.Swi switch position
    ipc.writeLvar("F22_SW_LT_MODE",LTMODEI)	-- Int.Lt.Swi nach oben
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 2 then
  LTMODEI=ipc.readLvar("F22_SW_LT_MODE")
  if LTMODEI > 0 then
    LTMODEI=LTMODEI-1						-- decrement Int.Lt.Swi switch position
    ipc.writeLvar("F22_SW_LT_MODE",LTMODEI)	-- Int.Lt.Swi nach oben
    ipc.writeLvar("SWITCH_CLICK_OFF",1)		-- Schaltersound off/n.unten
  end	
-- 
-- Parm  3/4  : Exterior lights OFF/POS+ANTICOLL/ANTICOLL
--
elseif ipcPARAM == 3 then
  LTMODEX=ipc.readLvar("F22_KNOB_LT_POS_ANTICOL")
  if LTMODEX < 2 then
    LTMODEX=LTMODEX+1						-- increment Int.Lt.Swi switch position
    ipc.writeLvar("F22_KNOB_LT_POS_ANTICOL",LTMODEX)	-- Int.Lt.Swi nach oben
    ipc.writeLvar("KNOB_CLICK",1)			-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 4 then
  LTMODEX=ipc.readLvar("F22_KNOB_LT_POS_ANTICOL")
  if LTMODEX > 0 then
    LTMODEX=LTMODEX-1						-- decrement Int.Lt.Swi switch position
    ipc.writeLvar("F22_KNOB_LT_POS_ANTICOL",LTMODEX)	-- Int.Lt.Swi nach oben
    ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
  end	
-- 
-- Parm  5/6  : Landing/Taxi lights TAXI/OFF/LAND
--
elseif ipcPARAM == 5 then
  LTMLNTX=ipc.readLvar("F22_SW_LAND_TAXI")
  if LTMLNTX < 2 then
    LTMLNTX=LTMLNTX+1						-- increment Landing/Taxi switch position
    ipc.writeLvar("F22_SW_LAND_TAXI",LTMLNTX)	-- Landing/Taxi Swi nach oben
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 6 then
  LTMLNTX=ipc.readLvar("F22_SW_LAND_TAXI")
  if LTMLNTX > 0 then
    LTMLNTX=LTMLNTX-1						-- decrement Landing/Taxi switch position
    ipc.writeLvar("F22_SW_LAND_TAXI",LTMLNTX)	-- Landing/Taxi Swi nach oben
    ipc.writeLvar("SWITCH_CLICK_OFF",1)		-- Schaltersound off/n.unten
  end	
-- 
-- Parm  7/8  : Oxygen Mixture 100%/Auto
--  
elseif ipcPARAM == 7 then
  OXYMIX=ipc.readLvar("F22_SW_OXY_MIXTURE")
  if OXYMIX ~= 1 then
    ipc.writeLvar("F22_SW_OXY_MIXTURE",1)	-- Oxygen mixture Auto
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 8 then
  OXYMIX=ipc.readLvar("F22_SW_OXY_MIXTURE")
  if OXYMIX ~= 0 then
    ipc.writeLvar("F22_SW_OXY_MIXTURE",0)	-- Oxygen mixture 100%
    ipc.writeLvar("SWITCH_CLICK_OFF",1)		-- off/n.unten
  end	
-- 
-- Parm  9/10 : Oxygen mode normal/bypass
--
elseif ipcPARAM == 9 then
  OXYMODE=ipc.readLvar("F22_SW_OXY_MODE")
  if OXYMODE ~= 1 then
    ipc.writeLvar("F22_SW_OXY_MODE",1)		-- Oxygen Mode normal
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 10 then
  OXYMODE=ipc.readLvar("F22_SW_OXY_MODE")
  if OXYMODE ~= 0 then
    ipc.writeLvar("F22_SW_OXY_MODE",0)		-- Oxygen Mode bypass
    ipc.writeLvar("SWITCH_CLICK_OFF",1)		-- Schaltersound off/n.unten
  end	
--
-- Parm 11/12 : OBOGS on/off
--  
elseif ipcPARAM == 11 then
  OXYOBOGS=ipc.readLvar("F22_SW_OXY_PWR")
  if OXYOBOGS ~= 1 then
    ipc.writeLvar("F22_SW_OXY_PWR",1)		-- Oxygen OBOGS ON
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 12 then
  OXYOBOGS=ipc.readLvar("F22_SW_OXY_PWR")
  if OXYOBOGS ~= 0 then
    ipc.writeLvar("F22_SW_OXY_PWR",0)		-- Oxygen OBOGS OFF
    ipc.writeLvar("SWITCH_CLICK_OFF",1)		-- Schaltersound off/n.unten
  end	

--
-- Parm 13/14 : AAR door open/close (Luftbetankung)
--  
elseif ipcPARAM == 13 then
  AARDOOR=ipc.readLvar("F22_SW_AAR")
  if AARDOOR ~= 1 then
    ipc.writeLvar("F22_SW_AAR",1)			-- AAR door open
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 14 then
  AARDOOR=ipc.readLvar("F22_SW_AAR")
  if AARDOOR ~= 0 then
    ipc.writeLvar("F22_SW_AAR",0)			-- AAR door close
    ipc.writeLvar("SWITCH_CLICK_OFF",1)		-- Schaltersound off/n.unten
  end	

--
-- Parm 15/16 : Canopy open/close (für Switch, nicht toggle)
--  
elseif ipcPARAM == 15 then
  CANOPY=ipc.readUB(0x3367)
  CANOPY=logic.And(CANOPY,1)				-- Offset x3367, bit 1 is door status
  if CANOPY ~= 1 then
    ipc.setbitsUB(0x3367,1)					-- Open Canopy : set bit 1
    ipc.writeLvar("SWITCH_CLICK_ON",1)		-- Schaltersound on/n.oben
  end	
elseif ipcPARAM == 16 then
  CANOPY=ipc.readUB(0x3367)
  CANOPY=logic.And(CANOPY,1)				-- Offset x3367, bit 1 is door status
  if CANOPY ~= 0 then
    ipc.clearbitsUB(0x3367,1)					-- Close Canopy : reset bit 1
    ipc.writeLvar("KNOB_CLICK",1)		-- Schaltersound on/n.oben
  end	

--
-- Parm 17/18 : Turn Formation Lt Knob Left/Right
--
elseif ipcPARAM == 17 then
  FORMLT=ipc.readLvar("F22_KNOB_LT_FORM")
  if FORMLT > 0 then						-- add 1 to max. 5 (turn right)
     FORMLT=FORMLT - 1
    ipc.writeLvar("F22_KNOB_LT_FORM",FORMLT)	-- turn knob to right
    ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
  end	
elseif ipcPARAM == 18 then
  FORMLT=ipc.readLvar("F22_KNOB_LT_FORM")
  if FORMLT < 5 then						-- add 1 to max. 5 (turn right)
     FORMLT=FORMLT + 1
    ipc.writeLvar("F22_KNOB_LT_FORM",FORMLT)	-- turn knob to right
    ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
  end	
--
-- Parm 19/20 : Knob Console Light full right/left
--
elseif ipcPARAM == 19 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_CONSOLE")
  if KNOBPOS < 5 then
    while KNOBPOS < 5 do
	  KNOBPOS = KNOBPOS + 1
      ipc.writeLvar("F22_KNOB_LT_CONSOLE",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	
elseif ipcPARAM == 20 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_CONSOLE")
  if KNOBPOS > 0 then
    while KNOBPOS > 0 do
	  KNOBPOS = KNOBPOS - 1
      ipc.writeLvar("F22_KNOB_LT_CONSOLE",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	
--
-- Parm 21/22 : Knob Flood Light full right/left
--
elseif ipcPARAM == 21 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_FLOOD")
  if KNOBPOS < 5 then
    while KNOBPOS < 5 do
	  KNOBPOS = KNOBPOS + 1
      ipc.writeLvar("F22_KNOB_LT_FLOOD",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	
elseif ipcPARAM == 22 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_FLOOD")
  if KNOBPOS > 0 then
    while KNOBPOS > 0 do
	  KNOBPOS = KNOBPOS - 1
      ipc.writeLvar("F22_KNOB_LT_FLOOD",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	
--
-- Parm 23/24 : Knob MFD Light full right/left
--
elseif ipcPARAM == 23 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_MFD")
  if KNOBPOS < 5 then
    while KNOBPOS < 5 do
	  KNOBPOS = KNOBPOS + 1
      ipc.writeLvar("F22_KNOB_LT_MFD",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	
elseif ipcPARAM == 24 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_MFD")
  if KNOBPOS > 0 then
    while KNOBPOS > 0 do
	  KNOBPOS = KNOBPOS - 1
      ipc.writeLvar("F22_KNOB_LT_MFD",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	
--
-- Parm 25/26 : Knob Inst Light full right/left
--
elseif ipcPARAM == 25 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_INST")
  if KNOBPOS < 5 then
    while KNOBPOS < 5 do
	  KNOBPOS = KNOBPOS + 1
      ipc.writeLvar("F22_KNOB_LT_INST",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	
elseif ipcPARAM == 26 then
  KNOBPOS=ipc.readLvar("F22_KNOB_LT_INST")
  if KNOBPOS > 0 then
    while KNOBPOS > 0 do
	  KNOBPOS = KNOBPOS - 1
      ipc.writeLvar("F22_KNOB_LT_INST",KNOBPOS)	-- turn knob to right
      ipc.writeLvar("KNOB_CLICK",1)			-- Knopfklick
	  ipc.sleep(20)
    end
  end	

                   
---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("IRIS F22 Lights: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)   
end	
  

