--
-- 10.05.18/AH Learjet 35A Flysimware: Inc/Dec Autopilot Altitude
-- Parm=+Increment : Increment Autopilot Altitude by <parm> * 100 ft
-- Parm=-Increment : Decrement Autopilot Altitude by <parm> * 100 ft
-- Das macht normalerweise "Ap Alt Var Inc/Dec", beim Learjet muss aber auch ALERTER_DIGITAL für die Konsolanzeige gesetzt werden

if ipcPARAM == nil then
  return
end
-- Increment/Decrement in 100 ft
altincr=ipcPARAM * 100		-- Increment AP Altitude in 100 ft

--
-- Increment / Decrement ermitteln
--  
apalti=ipc.readLvar("L:ALERTER_DIGITAL")	-- Console Display in feet
newalti = apalti + altincr					-- auch bei Decrement addieren wg. negativem Wert !
if newalti < 0 or newalti > 99999 then					-- 0...99999 ft !
  return
end

--
-- AP Altitude changed
--
altfsx = (newalti * 65536) / 3.28084		-- FSX-internes Format: Meter * 65536, Umrechnung: 1 m = 3.28084 ft
altfsx = math.floor( ( ( altfsx / altincr ) + 0.5 ) * altincr ) -- auf Increment-Vielfache runden
ipc.writeLvar("L:ALERTER_DIGITAL", newalti)	-- Learjet LVAR auf Altitude (feet)
ipc.writeSD(0x7d4, altfsx)					-- FSX Offset auf Altitude (Meter * 65536)


