-- 10.05.18/AH  Flysimware Learjet 35A Controls: Autopilot (Al Klayton)
-- 11.05.18/AH  Die AP-Auswahl-Module werden nicht mehr benutzt. Es geht einfacher über Direktzuordnung, s. Flysimware Manual:
--				Damit wird auch beim Wechsel Nav->Hdg das Hdg aktiv 
--				Dieses Modul dient nur noch dem Einschalten des Autopiloten mit Parm 100/101
--				Achtung ! Damit ist nicht "Engage" gemeint, vielmehr der Schalter neben Radio Alt
-- Full list:
-- G1000_PFD_SOFTKEY1 = HDG
-- G1000_PFD_SOFTKEY2 = 1/2 BNK
-- G1000_PFD_SOFTKEY3 = NAV
-- G1000_PFD_SOFTKEY4 = BC
-- G1000_PFD_SOFTKEY5 = LVL
-- G1000_PFD_SOFTKEY6 = TST
-- G1000_PFD_SOFTKEY7 = ENG
-- G1000_PFD_SOFTKEY8 = SFT
-- G1000_PFD_SOFTKEY9 = SPD
-- G1000_PFD_SOFTKEY10 = V/S
-- G1000_PFD_SOFTKEY11 = GS
-- G1000_PFD_SOFTKEY12 = ALTSEL
-- G1000_MFD_SOFTKEY1 = ALTHLD
-- G1000_MFD_SOFTKEY2 = Steer Lock On
-- G1000_MFD_SOFTKEY3 = Steer Lock Off
-- G1000_MFD_SOFTKEY4 = Yaw Damper Primary (Power mode must be on.)
-- G1000_MFD_SOFTKEY5 = Yaw Damper Secondary (Power mode must be on.)
-- G1000_MFD_SOFTKEY6 = Spoiler Switch (Default switch is disabled. There is no arming as well.)
--
-- Autopilot Funktionen
-- Parm = 1 : AP HDG
-- Parm = 2 : AP NAV
-- Parm = 3 : AP GS (Lear kein APR, sondern NAV+GS)
-- Parm = 4 : AP LVL
-- Parm = 5 : AP REV/BC
-- Parm = 6 : AP ARM ALT
-- Parm = 7 : AP ALT HLD
-- Parm = 8 : AP VS
-- Parm = 9 : AP HalfBank
-- Parm =10 : AP SPD
-- Parm =11 : AP SFT 
-- Parm =12 : AP TST
-- Parm =100: Schalter "Autopilot" (neben Radio Alt) on
-- Parm =101: Schalter "Autopilot" (neben Radio Alt) off
--
if ipcPARAM == 100 then
  appwr=ipc.readLvar("L:AUTOPILOT")
  if appwr == 0 then
    ipc.writeLvar("L:AUTOPILOT",1)   --turn autopilot power switch on
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 101 then
  appwr=ipc.readLvar("L:AUTOPILOT")
  if appwr ~= 0 then
    ipc.writeLvar("L:AUTOPILOT",0)   --turn autopilot power switch off
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
end  
--
-- Achtung ! Die weiteren Funktionen wurden durch G1000-Variable ersetzt
--
--

--
-- Parm=1 : AP HDG
--
if ipcPARAM == 1 then
 
	ipc.writeLvar("L:HDG",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:HDG",0)
	hdg_mode=ipc.readLvar("L:MODE_HDG")
		
	if hdg_mode==0 then
	  ipc.writeLvar("L:MODE_HDG",1)   -- turn HDG mode on 
	else 
	  ipc.writeLvar("L:MODE_HDG",0)  -- -- turn HDG mode off 
	end   

	hdg_mode=ipc.readLvar("L:MODE_HDG")
	lvl_mode=ipc.readLvar("L:MODE_LVL")
	if hdg_mode==1 then
	  ipc.writeLvar("MODE_LVL",0)
	  ipc.writeLvar("MODE_NAV",0)
	end  
  return
--
-- Parm=2 : AP NAV
--
elseif ipcPARAM == 2 then
	ipc.writeLvar("L:NAV",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:NAV",0)
	nav_mode=ipc.readLvar("L:MODE_NAV")
		
	if nav_mode==0 then
	  ipc.writeLvar("L:MODE_NAV",1)   -- turn NAV mode on 
	else 
	  ipc.writeLvar("L:MODE_NAV",0)  -- -- turn NAV mode off 
	end   
  return
--
-- Parm=3 : AP GS (Approach = NAV + GS !)
--
elseif ipcPARAM == 3 then
	ipc.writeLvar("L:GS",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:GS",0)
	gs_mode=ipc.readLvar("L:MODE_GS")
		
	if gs_mode==0 then
	  ipc.writeLvar("L:MODE_GS",1)   -- turn GS mode on 
	else 
	  ipc.writeLvar("L:MODE_GS",0)  -- -- turn GS mode off 
	end   
  return
--
-- Parm=4 : AP LVL
--
elseif ipcPARAM == 4 then
	ipc.writeLvar("L:LVL",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:LVL",0)
		
	lvl_mode=ipc.readLvar("L:MODE_LVL")
		
	if lvl_mode==0 then
	  ipc.writeLvar("L:MODE_LVL",1)   -- turn LVL mode on 
	else 
	  ipc.writeLvar("L:MODE_LVL",0)  -- -- turn LVL mode off 
	end   

	lvl_mode=ipc.readLvar("L:MODE_LVL")    -- get updated value
	if lvl_mode==1 then
	  ipc.writeLvar("L:MODE_HDG",0) 
	end  
  return
--
-- Parm=5 : AP REV (BC)
--
elseif ipcPARAM == 5 then
	ipc.writeLvar("L:BC",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:BC",0)
	bc_mode=ipc.readLvar("L:MODE_BC")
		
	if bc_mode==0 then
	  ipc.writeLvar("L:MODE_BC",1)   -- turn BC mode on 
	else 
	  ipc.writeLvar("L:MODE_BC",0)  -- -- turn BC mode off 
	end   
  return  
--
-- Parm=6 : AP ARM ALT
--
elseif ipcPARAM == 6 then
	ipc.writeLvar("L:ALTSEL",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:ALTSEL",0)
		
	altsel_mode=ipc.readLvar("L:MODE_ALTSEL")
		
	if altsel_mode==0 then
	  ipc.writeLvar("L:MODE_ALTSEL",1)   -- turn alt sel mode on 
	else 
	  ipc.writeLvar("L:MODE_ALTSEL",0)  -- -- turn alt sel mode off 
	end
		
	spd_mode = ipc.readLvar("L:MODE_SPD")
	vs_mode = ipc.readLvar("L:MODE_VS")
	altsel_mode = ipc.readLvar("L:MODE_ALTSEL")
	althld_mode = ipc.readLvar("L:MODE_ALTHLD")
	alerter_digital=ipc.readLvar("L:ALERTER_DIGITAL")
	   
	if (spd_mode == 1 or vs_mode == 1) and altsel_mode == 1 then
	  ipc.control(66124,alerter_digital)    -- alerter altitude into AP_ALT_VAR_SET_ENGLISH
	end
	   
	if (spd_mode==0 and vs_mode==0) and (altsel_mode==1 and althld_mode == 0) then
	  ipc.control(65816)  -- AP_ALT_HOLD_OFF
	end
       
	if altsel_mode==1 then
	  ipc.writeLvar("L:MODE_ALTHLD", 0)
	  ipc.writeLvar("L:MODE_GS", 0) 		
	end   
  return
--
-- Parm=7 : AP ALT HLD
--
elseif ipcPARAM == 7 then
	ipc.writeLvar("L:ALTHLD",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:ALTHLD",0)
	althld_mode=ipc.readLvar("L:MODE_ALTHLD")
		
	if althld_mode==0 then
	  ipc.writeLvar("L:MODE_ALTHLD",1)   -- turn ALT HLD mode on 
	else 
	  ipc.writeLvar("L:MODE_ALTHLD",0)  --  turn ALT HLD mode off 
	end 
		
	althld_mode=ipc.readLvar("L:MODE_ALTHLD")

	if althld_mode==1  then
	  ipc.control(65808)  -- AP_ALT_HOLD_ON
	end
       
	if althld_mode==0  then
	  ipc.control(65816)  -- AP_ALT_HOLD_OFF
	end
		
	spd_mode = ipc.readLvar("L:MODE_SPD")
	vs_mode = ipc.readLvar("L:MODE_VS")
	althld_mode=ipc.readLvar("L:MODE_ALTHLD")
		
	if (spd_mode == 0 and vs_mode == 0) and altsel_mode == 0 then
	  ipc.control(66036,0)                                      -- 0 into AP_VS_VAR_SET_ENGLISH
	end 
		
	if althld_mode==1 then
	  ipc.writeLvar("L:MODE_SPD", 0)
	  ipc.writeLvar("L:MODE_VS", 0) 		
	  ipc.writeLvar("L:MODE_GS", 0)
	  ipc.writeLvar("L:MODE_ALTSEL", 0)
	end   
  return	
--
-- Parm=8 : AP VS
--
elseif ipcPARAM == 8 then
	ipc.writeLvar("L:VS",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:VS",0)
	vs_mode=ipc.readLvar("L:MODE_VS")
		
	if vs_mode==0 then
	  ipc.writeLvar("L:MODE_VS",1)   -- turn vs mode on 
	else 
	  ipc.writeLvar("L:MODE_VS",0)  -- -- turn vs mode off 
	end   
	vs_mode=ipc.readLvar("L:MODE_VS")
		
	if vs_mode==1  then
	  ipc.control(65808)  -- AP_ALT_HOLD_ON
	  ipc.writeLvar("L:MODE_VS_NODE", 1)
	end
       
	if  vs_mode==0  then
	  ipc.control(65816)  -- AP_ALT_HOLD_OFF
	  ipc.writeLvar("L:MODE_VS_NODE", 0)	
	end
		
	spd_mode=ipc.readLvar("L:MODE_SPD")
	vs_mode=ipc.readLvar("L:MODE_VS")
	altsel_mode=ipc.readLvar("L:MODE_ALTSEL") 
	alerter_digital=ipc.readLvar("L:ALERTER_DIGITAL")
	   
	if (spd_mode == 1 or vs_mode == 1) and altsel_mode == 1 then
	  ipc.control(66124,alerter_digital)                       -- alerter altitude into AP_ALT_VAR_SET_ENGLISH
	end 
       
	if (spd_mode == 0 and vs_mode == 0) and altsel_mode == 0 then
	  ipc.control(66036,0)                                      -- 0 into AP_VS_VAR_SET_ENGLISH
	end    
	   
	if vs_mode==1 then
	  ipc.writeLvar("L:MODE_SPD", 0)
	  ipc.writeLvar("L:MODE_GS", 0) 		
	  ipc.writeLvar("L:MODE_ALTHLD", 0)
	end 
  return  
--
-- Parm=9 : AP H_BNK
--
elseif ipcPARAM == 9 then
	ipc.writeLvar("L:BNC",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:BNC",0)
		
	bnc_mode=ipc.readLvar("L:MODE_BNC")
		
	if bnc_mode==0 then
	  ipc.writeLvar("L:MODE_BNC",1)   -- turn half bank mode on 
	  ipc.control(66710)              -- AP_MAX_BANK_DEC
	else 
	  ipc.writeLvar("L:MODE_BNC",0)  -- turn half bank mode off 
	end  
  return		
--
-- Parm=10 : AP SPD
--
elseif ipcPARAM == 10 then
	ipc.writeLvar("L:SPD",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:SPD",0)
	spd_mode=ipc.readLvar("L:MODE_SPD")
		
	if spd_mode==0 then
	  ipc.writeLvar("L:MODE_SPD",1)   -- turn spd mode on 
	else 
	  ipc.writeLvar("L:MODE_SPD",0)  -- -- turn spd mode off 
	end   
	spd_mode=ipc.readLvar("L:MODE_SPD")
		
	if spd_mode==1  then	   
	  ipc.control(65808)  -- AP_ALT_HOLD_ON
	  ipc.writeLvar("L:MODE_SPD_NODE", 1)
	end
       
	if  spd_mode==0  then
	  ipc.control(65816)  -- AP_ALT_HOLD_OFF
	  ipc.writeLvar("L:MODE_SPD_NODE", 0)
	end
		
	spd_mode=ipc.readLvar("L:MODE_SPD")
	vs_mode=ipc.readLvar("L:MODE_VS")
	altsel_mode=ipc.readLvar("L:MODE_ALTSEL") 
	alerter_digital=ipc.readLvar("L:ALERTER_DIGITAL")
	   
	if (spd_mode == 1 or vs_mode == 1) and altsel_mode == 1 then
	  ipc.control(66124,alerter_digital)                       -- alerter altitude into AP_ALT_VAR_SET_ENGLISH
	end 
       
	if (spd_mode == 0 and vs_mode == 0) and altsel_mode == 0 then
	  ipc.control(66036,0)                                      -- 0 into AP_VS_VAR_SET_ENGLISH
	end   	
		
	if spd_mode==1 then
	  ipc.writeLvar("L:MODE_VS", 0)
	  ipc.writeLvar("L:MODE_GS", 0) 		
	  ipc.writeLvar("L:MODE_ALTHLD", 0)
	end 
  return
--
-- Parm=11 : AP SFT
--
elseif ipcPARAM == 11 then
	ipc.writeLvar("L:SFT",1)        -- button movement
	ipc.sleep(100)
	ipc.writeLvar("L:SFT",0)
		
	sft_mode=ipc.readLvar("L:MODE_SFT")
		
	if sft_mode==0 then
	  ipc.writeLvar("L:MODE_SFT",1)   -- turn SOFT mode on 
	else 
	  ipc.writeLvar("L:MODE_SFT",0)  --  turn SOFT mode off 
	end   
  return
--
-- Parm=12 : AP TST
--
elseif ipcPARAM == 12 then
	ipc.writeLvar("L:MODE_TST",1)       --AP light test on
	ipc.sleep(2500)                     --delay, lights on for 2.5 sec
	ipc.writeLvar("L:MODE_TST",0)        --AP light test off
		 
	ipc.writeLvar("L:MODE_HDG",0)    -- turn HDG mode off 
	ipc.writeLvar("L:MODE_BNC",0)    -- turn BNC mode off 
	ipc.writeLvar("L:MODE_NAV",0)    -- turn NAV mode off 
	ipc.writeLvar("L:MODE_BC",0)    -- turn BC mode off 
	ipc.writeLvar("L:MODE_LVL",0)    -- turn LVL mode off 
	ipc.writeLvar("L:MODE_ENG",0)    -- turn ENG mode off 
	ipc.writeLvar("L:MODE_SFT",0)    -- turn SFT mode off 
	ipc.writeLvar("L:MODE_SPD",0)    -- turn SPD mode off 
	ipc.writeLvar("L:MODE_VS",0)    -- turn VS mode off 
	ipc.writeLvar("L:MODE_GS",0)    -- turn GS mode off 
	ipc.writeLvar("L:MODE_ALTSEL",0)   -- turn ALTSEL mode off 
	ipc.writeLvar("L:MODE_ALTHLD",0)    -- turn ALTHLD mode off 		
	ipc.control(65816)                -- AP_ALT_HOLD_OFF
	ipc.control(65791)               -- AUTOPILOT_OFF
  return
end  



