-- 25.03.18/AH Flysimware Learjet 35A Controls: Jet Pumps
--
-- Toggle Jet Pump Switches and Hydraulic Pump
--
-- Lear 35A Fuel System:
-- Jet Pumps sind immer an. Sie pumpen stetig vom Tip Tank zum Wing Tank, wenn dieser sich leert
-- Die Lampe an den Schaltern leuchten nur beim Einschalten kurz auf (Kontrolle)
-- Leuchten die Lampen dauerhaft, stimmt der Zustand der Ventile nicht !
-- Falls eine Jet Pump im Betrieb wieder eingeschaltet werden müsste, ist darauf zu achten, 
-- dass die Drehzahl der Turbine auf mindestens 80% ist, sonst kann es wg. des Druckabfalls zu einem Engine-Flameout kommen !
--
-- Standby Pumps werden automatisch vom Starter eingeschaltet, sie sind an, bis die Turbinen abgestellt werden.
-- Die Schalter für die Standby Pumps werden nur benutzt, um ungleiche Tankinhalte umzupumpen
-- Dazu wird der Cross Flow Schalter und die Standby Pump des volleren Tanks eingeschaltet.
--
-- Fuselage pump
-- Die Fuselage pump füllt (FILL) oder leert (XFER) den Fuselage Tank von/zu den Wing Tanks
-- Der Fuselage Tank ist die Reserve, d.h. wenn die Wing Tanks (fast) leer sind, wird aus dem Fuselage Tank
-- in die Wing Tanks umgepumpt.

-- LVARs für Pumpen:
--      ipc.writeLvar("L:SW_COMPLEFT",1)		
--		ipc.writeLvar("L:SW_COMPRIGHT",1)
--      ipc.writeLvar("L:FUEL_SECPUMP1",1)		
--		ipc.writeLvar("L:FUEL_SECPUMP2",1)
--      ipc.writeLvar("L:FUEL_MAINPUMP1",1)		
--		ipc.writeLvar("L:FUEL_MAINPUMP2",1)	
-- desweiteren aus Learjet_35A_interior.MDL im Subfolder model.MAIN (if-statements)
-- L:TIMER_NODE1 für linke MAINPUMP1 Lampe, ebenso TIMER_NODE2 für rechte MAINPUMP2 Lampe
	
--
-- Parm =  1 : Fuelpumps Toggle
-- Parm =  2 : Fuelpumps Pri/Sec
-- Parm =  3 : Fuselage Pump Up
-- Parm =  4 : Fuselage Pump Dn
-- Parm = 10 : Hydraulic Pump up
-- Parm = 11 : Hydraulic Pump up
-- Parm = 20 : Fuel Computer both on
-- Parm = 21 : Fuel Computer both off

if ipcPARAM == 1 then
  JetPumpL=ipc.readLvar("L:FUEL_MAINPUMP1")		-- Left Jet Pump bestimmt Status
-- Stand 14.05.18 nicht bekannt: wie bekomme ich die LEDs an den Jetpump-Switchen zum leuchten ?
  if JetPumpL == 0 then
    ipc.writeLvar("L:FUEL_MAINPUMP1",1)			-- Left Jet Pump on
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
    ipc.writeLvar("L:TIMER_NODE1",1)			-- Trigger Left Jet Pump Lamp for some seconds on
    ipc.sleep(500)								-- wait shortly, so one can see the lamp going on ;-) 
    ipc.writeLvar("L:FUEL_MAINPUMP2",1)			-- Right Jet Pump on
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
    ipc.writeLvar("L:TIMER_NODE2",1)			-- Trigger Right Jet Pump Lamp for some seconds on
	
  else	
    ipc.writeLvar("L:FUEL_MAINPUMP1",0)			-- Left Jet Pump off
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
    ipc.sleep(250) 
    ipc.writeLvar("L:FUEL_MAINPUMP2",0)			-- Right Jet Pump off
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
  end  
  return
elseif ipcPARAM == 2 then
  StdbyPumpL=ipc.readLvar("L:FUEL_SECPUMP1")	-- Left Standby Pump bestimmt Status
  if StdbyPumpL == 0 then
    ipc.writeLvar("L:FUEL_SECPUMP1",1)			-- Left Standby Pump on
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
    ipc.sleep(250) 
    ipc.writeLvar("L:FUEL_SECPUMP2",1)			-- Right Standby Pump on
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
  else	
    ipc.writeLvar("L:FUEL_SECPUMP1",0)			-- Left Standby Pump off
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
    ipc.sleep(250) 
    ipc.writeLvar("L:FUEL_SECPUMP2",0)			-- Right Standby Pump off
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
  end  
  return
elseif (ipcPARAM == 3) or (ipcPARAM == 4) then
  fuspump=ipc.readLvar("L:FUEL_XFER")	
  if (ipcPARAM == 3) and (fuspump > -1) then
    newfuspump=fuspump - 1						-- Fuselage Pump Switch up
  elseif (ipcPARAM == 4) and (fuspump < 1) then
    newfuspump=fuspump + 1						-- Fuselage Pump Switch down
  else
    newfuspump = fuspump						-- no change
  end
  if newfuspump ~= fuspump then
    ipc.writeLvar("L:FUEL_XFER",newfuspump)
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
  end  
  return
elseif (ipcPARAM == 10) or (ipcPARAM == 11) then
  hydpump=ipc.readLvar("L:SW_HYD")	
  if (ipcPARAM == 10) and (hydpump < 1) then
    newhydpump=hydpump + 1						-- Hydraulic Pump Switch on
  elseif (ipcPARAM == 11) and (hydpump > 0) then
    newhydpump=hydpump - 1						-- Hydraulic Pump Switch off
  else
    newhydpump = hydpump						-- no change
  end
  if newhydpump ~= hydpump then
    ipc.writeLvar("L:SW_HYD",newhydpump)
    ipc.writeLvar("L:XMLSND2",1)				-- switch sound
  end  
  return
elseif (ipcPARAM == 20) or (ipcPARAM == 21) then
  fuelcompl=ipc.readLvar("L:SW_COMPLEFT")		
  newfuelcompl=fuelcompl						-- Fuel Comp right save state
  fuelcompr=ipc.readLvar("L:SW_COMPRIGHT")		
  newfuelcompr=fuelcompr						-- Fuel Comp right leave as is
  if (ipcPARAM == 20) then
-- Switch fuel comp on
    if fuelcompl < 1 then
      newfuelcompl=1								-- Fuel Comp left on
	end  
	if fuelcompr < 1 then
      newfuelcompr=1								-- Fuel Comp right on
	end
-- Switch fuel comp off
  elseif (ipcPARAM == 21) then
    if fuelcompl > 0 then
      newfuelcompl=0								-- Fuel Comp left off
	end  
	if fuelcompr > 0 then
      newfuelcompr=0								-- Fuel Comp right off
	end
  end	
-- Check left fuel computer  
  if newfuelcompl ~= fuelcompl then
    ipc.writeLvar("L:SW_COMPLEFT",newfuelcompl)
    ipc.writeLvar("L:XMLSND70",1)				-- switch sound
    ipc.sleep(300) 
  end 
-- Check right fuel computer  
  if newfuelcompr ~= fuelcompr then
    ipc.writeLvar("L:SW_COMPRIGHT",newfuelcompr)
    ipc.writeLvar("L:XMLSND70",1)				-- switch sound
  end 
  return
end  