-- 23.03.18/AH  Flysimware Learjet 35A Controls: Generator/Starter Switch ; Inverter 
-- Parm: 1 = Linken Gen/Starter hochschalten
-- Parm: 2 = Linken Gen/Starter runterschalten
-- Parm: 3 = Rechten Gen/Starter hochschalten
-- Parm: 4 = Rechten Gen/Starter runterschalten
-- Parm: 10 = Beide Inverter ein
-- Parm: 11 = Beide Inverter aus
-- Parm: 20 = Air Ignition (Selective Ignition) left toggle
-- Parm: 21 = Air Ignition (Selective Ignition) right toggle
-- "Selective ignition is used for all takeoffs and landings and 
--  any time the pilot is concerned about the engine operating conditions.
--  It can also be used for airstarts. It can be used continuously when
--  flying in heavy precipitation, icing conditions or turbulent ar.
--  There is no time limit on the use of the ignition system however,
--  it should be used only when necessary to avoid excessive igniter plug erosion"

--
-- Left Generator/Starter switch upward
--
if ipcPARAM == 1 then 
  StrtState=ipc.readLvar("LEAR_STARTER_L") -- get Left Gen/Starter state
  if StrtState > -1 then
    StrtState=StrtState-1					-- Switch upward: Generator -> Off -> Starter
    ipc.writeLvar("LEAR_STARTER_L",StrtState)   -- Set Gen/Starter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 2 then  
  StrtState=ipc.readLvar("LEAR_STARTER_L") -- get Left Gen/Starter state
  if StrtState < 1 then
    StrtState=StrtState+1					-- Switch downward: Starter-> Off -> Generator 
    ipc.writeLvar("LEAR_STARTER_L",StrtState)   -- Set Gen/Starter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end
  return
elseif ipcPARAM == 3 then 
  StrtState=ipc.readLvar("LEAR_STARTER_R") -- get Right Gen/Starter state
  if StrtState > -1 then
    StrtState=StrtState-1					-- Switch upward: Generator -> Off -> Starter
    ipc.writeLvar("LEAR_STARTER_R",StrtState)   -- Set Gen/Starter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 4 then  
  StrtState=ipc.readLvar("LEAR_STARTER_R") -- get Right Gen/Starter state
  if StrtState < 1 then
    StrtState=StrtState+1					-- Switch downward: Starter-> Off -> Generator 
    ipc.writeLvar("LEAR_STARTER_R",StrtState)   -- Set Gen/Starter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
--
-- Switch Both Inverter on
--
elseif ipcPARAM == 10 then  
  InvState=ipc.readLvar("L:INV_PRI") -- get left Inverter state
  if InvState < 1 then
    InvState=1					-- left Inverter on
    ipc.writeLvar("L:INV_PRI",InvState)   -- Set left Inverter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  ipc.sleep(300)
  InvState=ipc.readLvar("L:INV_SEC") -- get right Inverter state
  if InvState < 1 then
    InvState=1					-- right Inverter on
    ipc.writeLvar("L:INV_SEC",InvState)   -- Set right Inverter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
--
-- Switch Both Inverter on
--
elseif ipcPARAM == 11 then  
  InvState=ipc.readLvar("L:INV_PRI") -- get left Inverter state
  if InvState ~= 0 then
    InvState=0					-- left Inverter off
    ipc.writeLvar("L:INV_PRI",InvState)   -- Set left Inverter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  ipc.sleep(300)
  InvState=ipc.readLvar("L:INV_SEC") -- get right Inverter state
  if InvState ~= 0 then
    InvState=0					-- right Inverter off
    ipc.writeLvar("L:INV_SEC",InvState)   -- Set left Inverter
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
--
-- Toggle  Air Ignition Left
--
elseif ipcPARAM == 20 then  
  AIgnState=ipc.readLvar("L:AIRSTART_L") -- get left Air Ignition state
  if AIgnState < 1 then
    AIgnState=1							-- left Air Ignition on
  else	
    AIgnState=0							-- left Air Ignition off
  end	
  ipc.writeLvar("L:AIRSTART_L",AIgnState)   -- Set left Air Ignition
  ipc.writeLvar("L:XMLSND70",1)  --switch sound
  return  
--
-- Toggle  Air Ignition Right
--
elseif ipcPARAM == 21 then  
  AIgnState=ipc.readLvar("L:AIRSTART_R") -- get left Air Ignition state
  if AIgnState < 1 then
    AIgnState=1							-- left Air Ignition on
  else	
    AIgnState=0							-- left Air Ignition off
  end	
  ipc.writeLvar("L:AIRSTART_R",AIgnState)   -- Set right Air Ignition
  ipc.writeLvar("L:XMLSND70",1)  --switch sound
  return  
end    


	  
