-- 23.03.18/AH  Flysimware Learjet 35A Controls: Beleuchtung
--				Parm: 1 = Internal Lights toggle
--				Parm: 2 = Taxi/Landing Lights hochschalten
--				Parm: 3 = Taxi/Landing Lights runterschalten
--				Parm: 4 = Recoc Light toggle
-- 10.05.18/AH  Anpassung an T&T (Switch, kein Taster; kein Sound):
--				Parm: 10 = Cabin Lt -> Flood Lights max
--				Parm: 11 = Flood Lights off
--				Parm: 12 = Instr Lt -> Instr/Panel/HSI max
--				Parm: 13 = Instr Lt off
--				Parm: 14 = El.Pnl max
--				Parm: 15 = El.Pnl off
--				Parm: 16 = Taxi/Landing Lights : Enable
--				Parm: 17 = Taxi/Landing Lights : Disable
--				Parm: 18 = Taxi/Landing Lights : Landing Lt
--				Parm: 19 = Taxi/Landing Lights : Taxi Lt
--				Parm: 20 = Seatbelt/Smoking Lt Up

--
-- Internal Lights (T&T)
--
if ipcPARAM == 10 then
  actstate=ipc.readLvar("LTS_FLOOD")
  if actstate < 5 then
    ipc.writeLvar("LTS_FLOOD",5) -- Flood lights max
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 11 then
  actstate=ipc.readLvar("LTS_FLOOD")
  if actstate ~= 0 then
    ipc.writeLvar("LTS_FLOOD",0) -- Flood lights off
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 12 then
  actstate=ipc.readLvar("LTS_HSI")
  if actstate < 6 then
    ipc.writeLvar("LTS_HSI",6) -- HSI lights on max
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
    ipc.sleep(150)  
  end	
  actstate=ipc.readLvar("LTS_PNL")
  if actstate < 5 then
    ipc.writeLvar("LTS_PNL",5) -- Instrument lights on max
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 13 then
  actstate=ipc.readLvar("LTS_PNL")
  if actstate ~= 0 then
    ipc.writeLvar("LTS_PNL",0) -- Instrument lights off
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
    ipc.sleep(150)
  end	
  actstate=ipc.readLvar("LTS_HSI")
  if actstate ~= 0 then
    ipc.writeLvar("LTS_HSI",0) -- HSI lights off
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 14 then
  actstate=ipc.readLvar("LTS_EL")
  if actstate < 5 then
    ipc.writeLvar("LTS_EL",5) -- Panel lights on max
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 15 then
  actstate=ipc.readLvar("LTS_EL")
  if actstate ~= 0 then
    ipc.writeLvar("LTS_EL",0) -- Panel lights on max
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end  
  return
--
-- Taxi/Landing Lights hochschalten (T&T)
-- Schaltung: T10=Enable Taxi/Ldg, T11=Taxi/Ldg
-- Benutzt FSX User Area ab 0x66C0
-- 1 unsigned Byte in 0x66C0 für EnabState: 0=Taxi/Ldg disab, 1=Taxi/Ldg enab
-- 1 unsigned Byte in 0x66C1 für Former Position: 0=Taxi, 1=Ldg
--  
elseif ipcPARAM == 16 then  
  ipc.writeUB(0x66C0,1)				-- Write "Enable Taxi/Ldg" to FSX User Area
  TxLdState=ipc.readUB(0x66C1)		-- Read "Former Position" from FSX User Area
  if TxLdState == 1 then
    ipc.writeLvar("L:TAXI_LAND",1)  -- Position: Landing Lights on
    ipc.writeLvar("L:XMLSND70",1)	--switch sound
  else	
    ipc.writeLvar("L:TAXI_LAND",0) 	-- Position: Taxi Lights on
    ipc.writeLvar("L:XMLSND70",1)	--switch sound
  end
  return
elseif ipcPARAM == 17 then  
  ipc.writeUB(0x66C0,0)				-- Write "Disable Taxi/Ldg" to FSX User Area
  ipc.writeLvar("L:TAXI_LAND",-1)   -- Taxi/Land off
  ipc.writeLvar("L:XMLSND70",1)  	--switch sound
  return
elseif ipcPARAM == 18 then  
  ipc.writeUB(0x66C1,1)				-- Write "Former Position Landing Lt" to FSX User Area
  TxLdEnab=ipc.readUB(0x66C0)		-- Read "Enable Taxi/Ldg" to FSX User Area
  if TxLdEnab == 1 then
    ipc.writeLvar("L:TAXI_LAND",1)  -- Position: Landing Lights on
    ipc.writeLvar("L:XMLSND70",1)	--switch sound
  end  
  return
elseif ipcPARAM == 19 then  
  TxLdEnab=0
  ipc.writeUB(0x66C1,0)				-- Write "Former Position Taxi Lt" to FSX User Area
  TxLdEnab=ipc.readUB(0x66C0)		-- Read "Enable Taxi/Ldg" to FSX User Area
  if TxLdEnab == 1 then
    ipc.writeLvar("L:TAXI_LAND",0)  -- Position: Taxi Lights on
    ipc.writeLvar("L:XMLSND70",1)	--switch sound
  end  
  return
--
-- Seatbelts/Smoking einschalten (TT) on
-- Der Schalter hat eigentlich drei Stellungen:
-- 0=off, -1=Nn smoking/fasten seat belts, 1=fasten seat belts
-- was aber nicht zu den TT on/off Schaltern passt.
-- Da heute ohnehin nicht mehr geschmaucht werden darf, schaltet 20/21 nur  zwischen 0 und -1 um
--  
elseif ipcPARAM == 20 then
  LtState=ipc.readLvar("L:SW_SMOKING") 		-- get state of Seatbelt/Smoking lights (1=bottom,0=mid,1=top)
  if LtState ~= -1 then
    SmokingLt=ipc.writeLvar("L:SW_SMOKING",-1) -- Seatbelt/Smoking lights state: Switch up
    ipc.writeLvar("L:XMLSND70",1)	--switch sound
  end	
  return
-- Seatbelts/Smoking ausschalten (TT)
elseif ipcPARAM == 21 then  --
  LtState=ipc.readLvar("L:SW_SMOKING") 		-- get state of Seatbelt/Smoking lights (1=bottom,0=mid,1=top)
  if LtState ~= 0 then
    SmokingLt=ipc.writeLvar("L:SW_SMOKING",0) -- Seatbelt/Smoking lights state: Switch off
    ipc.writeLvar("L:XMLSND70",1)	--switch sound
  end	
  return
-- Internal Lights (ThrQ)
--
elseif ipcPARAM == 1 then
  PanelLights=ipc.readLvar("LTS_PNL") -- get instrument lights state
  if PanelLights == 0 then
   	ipc.writeLvar("LTS_PNL",5) -- Instrument lights on max
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
	ipc.sleep(150)   
   	ipc.writeLvar("LTS_EL",5) -- Panel lights on max
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
	ipc.sleep(150)   
   	ipc.writeLvar("LTS_FLOOD",5) -- Flood lights on max
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
	ipc.sleep(150)   
   	ipc.writeLvar("LTS_HSI",6) -- HSI lights on max
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
  else
   	ipc.writeLvar("LTS_PNL",0) -- Instrument lights off
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
	ipc.sleep(150)   
   	ipc.writeLvar("LTS_EL",0) -- Panel lights off
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
	ipc.sleep(150)   
   	ipc.writeLvar("LTS_FLOOD",0) -- Flood lights off
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
	ipc.sleep(150)   
   	ipc.writeLvar("LTS_HSI",0) -- HSI lights off
	ipc.writeLvar("L:XMLSND70",1)   -- switch sound		
  end
  return
--
-- Taxi/Landing Lights hochschalten (ThrQ)
--  
elseif ipcPARAM == 2 then  
  LndLights=ipc.readLvar("L:TAXI_LAND") -- get Taxi/Landing lights state
  if LndLights < 1 then
    LndLights=LndLights+1				-- Off -> Taxi -> Landing
    ipc.writeLvar("L:TAXI_LAND",LndLights)   -- Set Taxi/Landing Lights
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 3 then  
  LndLights=ipc.readLvar("L:TAXI_LAND") -- get Taxi/Landing lights state
  if LndLights > -1 then
    LndLights=LndLights-1				-- Landing -> Taxi -> Off
    ipc.writeLvar("L:TAXI_LAND",LndLights)   -- Set Taxi/Landing Lights
    ipc.writeLvar("L:XMLSND70",1)  --switch sound
  end	
  return
elseif ipcPARAM == 4 then  
  ipc.control(66377)   --recognition lights toggle control
  return
end

	  
