-- 24.09.19/AH  Mooney Bravo Fuelvalve Toggle mit P3D Standardoffsets
-- Offset 0AF8 : Word
-- Fuel tank selector:	0=None, 1=All, 2=Left, 3=Right, 4=LeftAux,
-- 						5=RightAux, 6=Centre, 7=Centre2, 8=Centre3,
--						9=External1, 10=External2, 11=Right Tip, 12=Left Tip,
--						14=Crossfeed LtoR, 15=Crossfeed RtoL.According to information received,
--						in FS2002 all of these except the wing tip tanks can be selected and drained
-- Implementiert fuer Mooney Bravo: Left <-> None <-> Right
-- Parameter: 1 = nach Links ; 2 = nach Rechts 

--
-- FUELSEL=1 (All) ist initialer Status beim Sim-Start oder bei CTRL-E
-- Dabei wird wohl auch das Mooney-Fuel-System initialisiert.
-- Damit in diesem initialen Zustand der Fuelswitch beim ersten Mal schaltet, wird daher
-- folgender Workaround eingesetzt:
-- Wenn FUELSEL = 1 dann rechts/links setzen, zwei Sekunden warten, nochmal ann auf rechts/links setzen.
-- Das muss nur in diesem Initialisierungszustand (Sim-Start oder Ctrl-E) gemacht werden.
-- Das Problem tritt auch beim Schalten mit der Maus auf: beim allerersten Schalten dreht sich der Schalter nicht,
-- erst ab dem zweiten Schaltvorgang
--
-- ipc.lineDisplay("ipcPARAM:" .. ipcPARAM,1)
-- ipc.sleep(2000)
--

FUELSEL=ipc.readUW(0x0AF8)
if (FUELSEL ~= 1) then
--
-- ipcPARAM = 1 -> Fuel Selector von rechts nach links schalten
--
  if (ipcPARAM == 1) then
-- Fuel selector right (3) ? Then off  (0)
    if (FUELSEL == 3) then
      ipc.writeUW(0x0AF8, 0)
    else
      ipc.writeUW(0x0AF8, 2)
    end
--
-- ipcPARAM = 2 -> Fuel Selector von links nach rechts schalten
--
  elseif (ipcPARAM == 2) then
    FUELSEL=ipc.readUW(0x0AF8)
-- Fuel selector left (2) ? Then off  (0)
    if (FUELSEL == 2) then
      ipc.writeUW(0x0AF8, 0)
    else
      ipc.writeUW(0x0AF8, 3)
    end
  end
else  
-- Workaround fuer Mooney Bravo Fuel Selector Problem mit Ctrl-E
-- FUELSEL=1 und ipcPARAM=1 -> FUELSEL nach 2 Sek. erneut auf 2 (Left)
  if (ipcPARAM == 1) then
    ipc.writeUW(0x0AF8, 2)
    ipc.sleep(2000)
	dummy=ipc.readUW(0x0AF8)
    ipc.writeUW(0x0AF8, 2)
-- Workaround fuer Mooney Bravo Fuel Selector Problem mit Ctrl-E
-- FUELSEL=1 und ipcPARAM=2 -> FUELSEL nach 2 Sek. erneut auf 3 (Right)
  elseif (ipcPARAM == 2) then
    ipc.writeUW(0x0AF8, 3)
    ipc.sleep(2000)
	dummy=ipc.readUW(0x0AF8)
    ipc.writeUW(0x0AF8, 3)
  end
end
