-- 01.01.21/AH Qualitywings AVRO RJ Controls (Geklaut from Günter Steiner)
-- Params:
--  1,2,3,4 : Toggle Fuelpumps (1=Left Outer, 2=Left Inner, 3=Right Outer, 4=Right Inner)
--  5+6  : APU Start/Stop
--  7+8  : APU On/Off-Reset (skip position "Offline")
--  9+10 : Autopilot, Avionics, Antiskid and Lift Spoilers on/off
-- 11	 : Toggle Yaw Damper
-- 12	 : Toggle IRS 1+2 NAV/OFF (IRS 1 has position lead)

--
--  1,2,3,4 : Toggle Fuelpumps (1=Left Outer, 2=Left Inner, 3=Right Outer, 4=Right Inner)
--
if ipcPARAM == 1 then
  ipc.writeLvar("fuel_l_outer_pump_feed_switch_clicked", 1)
  return
elseif ipcPARAM == 2 then
  ipc.writeLvar("fuel_l_inner_pump_feed_switch_clicked", 1)
  return
elseif ipcPARAM == 3 then
  ipc.writeLvar("fuel_r_outer_pump_feed_switch_clicked", 1)
  return
elseif ipcPARAM == 4 then
  ipc.writeLvar("fuel_r_inner_pump_feed_switch_clicked", 1)
  return
--
--  5+6 : APU Start/Stop
--
elseif ipcPARAM == 5 then
  if ipc.readLvar("apu_start_switch") == 0 then
    ipc.writeLvar("apu_start_switch_clicked", 1)	
  end	
  return
elseif ipcPARAM == 6 then
  if ipc.readLvar("apu_start_switch") == 1 then
    ipc.writeLvar("apu_start_switch_clicked", 1)
  end
  return
--
--  7+8 : APU On/Off-Reset (skip position "Offline")
--
elseif ipcPARAM == 7 then
  apugenstat=ipc.readLvar("elec_apu_gen_switch")  -- apugenstat: 0=Off/Reset 2=Ofline 1=On
  if apugenstat == 0 or apugenstat == 2 then
    ipc.writeLvar("elec_apu_gen_switch_clicked", 2)
    if apugenstat ==  0 then
      ipc.sleep(300)
      ipc.writeLvar("elec_apu_gen_switch_clicked", 2)
	end  
  end	
  return
elseif ipcPARAM == 8 then
  apugenstat=ipc.readLvar("elec_apu_gen_switch")  -- apugenstat: 0=Off/Reset 2=Ofline 1=On
  if apugenstat == 1 or apugenstat == 2 then
    ipc.writeLvar("elec_apu_gen_switch_clicked", 1)
    if apugenstat == 1 then
      ipc.sleep(300)
      ipc.writeLvar("elec_apu_gen_switch_clicked", 1)
	end  
  end
  return
--
--  9+10 : Autopilot, Avionics, Antiskid and Lift Spoilers on/off
--
elseif ipcPARAM == 9 then
-- Autopilot Master on
  if ipc.readLvar("autopilot_master_switch") == 0 then
    ipc.writeLvar("autopilot_master_switch_clicked", 1)
  end
-- Avionics Master on  
  ipc.sleep(200)
  if ipc.readLvar("avionics_master_switch") == 0 then
    ipc.writeLvar("avionics_master_switch_clicked", 1)
  end
-- Antiskid on  
  ipc.sleep(200)
  antiskid=ipc.readLvar("antiskid_switch")
  if antiskid == 0 or antiskid == 2 then
    ipc.writeLvar("antiskid_switch_clicked", 2)
    if antiskid == 0 then
      ipc.sleep(300)
      ipc.writeLvar("antiskid_switch_clicked", 2)
    end  
  end	
-- Auto Spoiler on  
  ipc.sleep(200)
  if ipc.readLvar("auto_splr_switch") == 0 then
    ipc.writeLvar("auto_splr_switch_clicked", 1)
  end
-- Yellow lift spoiler on
  ipc.sleep(200)
  if ipc.readLvar("yellow_lift_splr_switch") == 0 then
    ipc.writeLvar("yellow_lift_splr_switch_clicked", 1)
  end
-- Green lift spoiler on
  ipc.sleep(200)
  if ipc.readLvar("green_lift_splr_switch") == 0 then
    ipc.writeLvar("green_lift_splr_switch_clicked", 1)
  end
  return
elseif ipcPARAM == 10 then
-- Autopilot Master off
  if ipc.readLvar("autopilot_master_switch") == 1 then
    ipc.writeLvar("autopilot_master_switch_clicked", 1)
  end
-- Avionics Master off
  ipc.sleep(200)
  if ipc.readLvar("avionics_master_switch") == 1 then
    ipc.writeLvar("avionics_master_switch_clicked", 1)
  end
-- Antiskid Batt 
  ipc.sleep(200)
  antiskid=ipc.readLvar("antiskid_switch")
  if antiskid == 1 or antiskid == 2 then
    ipc.writeLvar("antiskid_switch_clicked", 1)
    if antiskid == 1 then
      ipc.sleep(300)
      ipc.writeLvar("antiskid_switch_clicked", 1)
    end  
  end	
-- Auto Spoiler off  
  ipc.sleep(200)
  if ipc.readLvar("auto_splr_switch") == 1 then
    ipc.writeLvar("auto_splr_switch_clicked", 1)
  end
-- Yellow lift spoiler off
  ipc.sleep(200)
  if ipc.readLvar("yellow_lift_splr_switch") == 1 then
    ipc.writeLvar("yellow_lift_splr_switch_clicked", 1)
  end
-- Green lift spoiler off
  ipc.sleep(200)
  if ipc.readLvar("green_lift_splr_switch") == 1 then
    ipc.writeLvar("green_lift_splr_switch_clicked", 1)
  end
  return
--
-- 11 : Toggle Yaw Damper
--
elseif ipcPARAM == 11 then
  ipc.writeLvar("yaw_damper_switch_clicked", 1)
  return
--
-- 12 : Toggle IRS 1+2 NAV/OFF (IRS 1 has position lead)
--
elseif ipcPARAM == 12 then
  irs1knob=ipc.readLvar("irs1_knob")
  irs2knob=ipc.readLvar("irs2_knob")		-- IRS2 should be equal to IRS1 at this point
  ipc.writeLvar("irs1_knob_clicked", 1)
  if irs2knob == irs1knob then
    ipc.sleep(500)
    ipc.writeLvar("irs2_knob_clicked", 1)
  end
  return 
 
---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("QW_Avro_RJ_Controls: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)     
end	