-- 23.04.17/AH Turbine Duke V2 Ignition Switches
-- 13.05.18/AH Fuelpump von Toggle Electr. Fuelpump 1/2) 
--
--	Param=1 	-> Fuelpump Left, Switch von oben nach unten durchschalten (Folge 0 -> 1 -> 2)
--  Param=2		-> Fuelpump Left, Switch von unten nach oben durchschalten (Folge 2 -> 1 -> 0)
--  Param=3		-> Fuelpump Right, Switch von unten nach oben durchschalten (Folge 2 -> 1 -> 0)
--	Param=4 	-> Fuelpump Right, Switch von oben nach unten durchschalten (Folge 0 -> 1 -> 2)
--  Param=10    -> Left Fuel Selector clockwise (100->50->0)
--  Param=11    -> Left Fuel Selector counter-clockwise (100->50->0)
--	sonst 		-> nix machen, raus
--  
-- Funktion:
-- Die Position der Schalter laesst sich aus L:FuelPumpswitchL / L:FuelPumpswitchR auslesen
-- Schalter = 2 : unten, Schalter = 0 : oben
-- Diese Variable wird aber nur gelesen, sie darf nicht modifiziert werden
-- Zum Modifizieren von Schalter und Pumpe:
-- Auswahl der Pumpe über L:fuelPumpL / L:FuelPumpswitchR (jeweis Pumpe 1 = 0, Pumpe 2 = 1) 
-- dann Aktivieren der Auswahl mit FSX Toggle Fuelpump 1 (Left, Control 66340) / Toggle Fuelpump 2 (Right, Control 66341)
-- Zur Fehlervermeidung wird der Status von Schalter und aktuellem FSX Pumpenstate (x3B98 / x3AD8) geprüft
-- und nur der Toggle aufgerufen, wenn Schalterstatus und Pumpenstatus nicht zusammenpassen.
--


--
-- Left Pump Switch
--
if (ipcPARAM == 1) or (ipcPARAM == 2) then
  SwiPos = ipc.readLvar("L:FuelPumpswitchL")
-- Schalterposition nur innerhalb der Grenzen 0..2 verändern  
  if (ipcPARAM == 1) and (SwiPos > 0) then			-- ipcPARAM 1 : Linker Schalter nach oben (2->1->0)
    NewSwiPos = SwiPos - 1
  elseif (ipcPARAM == 2) and (SwiPos < 2) then		-- ipcPARAM 2 : Linker Schalter nach unten (0->1->2)
    NewSwiPos = SwiPos + 1
  else
    NewSwiPos = SwiPos
  end
-- Wurde Schalter verändert ?
  if NewSwiPos ~= SwiPos then	
	SwiPos = NewSwiPos
    ipc.writeLvar("L:FuelPumpswitchL",SwiPos)
-- Auswahl der Schalterposition on (0=oben, 1=unten)	
	if SwiPos == 2 then
	  ipc.writeLvar("L:FuelPumpL",1)			 -- Select Switch Position "Pump 2"
	else
	  ipc.writeLvar("L:FuelPumpL",0)			 -- Select Switch Position "Pump 1"
	end  
-- Seitherigen Pumpenstatus aus FSX holen	
	fpumpstat=ipc.readUB(0x3B98)				-- FSX Offset: State of Left Pump
-- Muss der FSX Pumpenstatus verändert werden ?	
	if SwiPos == 1 and fpumpstat ~= 0 then		-- Switch is off but Pump is running
	  ipc.control(66340)						-- Toggle Left Pump (to off)
	elseif SwiPos ~=1 and fpumpstat == 0 then	-- Switch is on but Pump is not running
	  ipc.control(66340)						-- Toggle Left Pump (to on)
	end  
  end
  return  
--
-- Right Pump Switch
--
elseif (ipcPARAM == 3) or (ipcPARAM == 4) then
  SwiPos = ipc.readLvar("L:FuelPumpswitchR")
-- Schalterposition nur innerhalb der Grenzen 0..2 verändern  
  if (ipcPARAM == 3) and (SwiPos > 0) then			-- ipcPARAM 3 : Rechter Schalter nach oben (2->1->0)
    NewSwiPos = SwiPos - 1
  elseif (ipcPARAM == 4) and (SwiPos < 2) then		-- ipcPARAM 4 : Rechter Schalter nach unten (0->1->2)
    NewSwiPos = SwiPos + 1
  else
    NewSwiPos = SwiPos
  end
-- Wurde Schalter verändert ?
  if NewSwiPos ~= SwiPos then	
	SwiPos = NewSwiPos
    ipc.writeLvar("L:FuelPumpswitchR",SwiPos)
-- Auswahl der Schalterposition on (0=oben, 1=unten)	
	if SwiPos == 2 then
	  ipc.writeLvar("L:FuelPumpR",1)			 -- Select Switch Position "Pump 2"
	else
	  ipc.writeLvar("L:FuelPumpR",0)			 -- Select Switch Position "Pump 1"
	end  
-- Seitherigen Pumpenstatus aus FSX holen	
	fpumpstat=ipc.readUB(0x3AD8)				-- FSX Offset: State of Right Pump
-- Muss der FSX Pumpenstatus verändert werden ?	
	if SwiPos == 1 and fpumpstat ~= 0 then		-- Switch is off but Pump is running
	  ipc.control(66341)						-- Toggle Right Pump (to off)
	elseif SwiPos ~=1 and fpumpstat == 0 then	-- Switch is on but Pump is not running
	  ipc.control(66341)						-- Toggle Right Pump (to on)
	end  
  end
  return  
--
-- Left Fuel Selector
--
elseif (ipcPARAM == 10) or (ipcPARAM == 11) then
  SwiPos = ipc.readLvar("L:Duke_Tank_Selector_L")
-- Schalterposition nur innerhalb der Grenzen 0..2 verändern  
  if (ipcPARAM == 10) and (SwiPos < 100) then			-- ipcPARAM 10 : Left Fuel Selector clockwise
    NewSwiPos = SwiPos + 50
  elseif (ipcPARAM == 11) and (SwiPos > 0) then			-- ipcPARAM 11 : Left Fuel Selector counterclockwise
    NewSwiPos = SwiPos - 50
  else
    NewSwiPos = SwiPos
  end
  if NewSwiPos ~= SwiPos then
    ipc.writeLvar("L:Duke_Tank_Selector_L",NewSwiPos)
  end
  return  
--
-- Right Fuel Selector
--
elseif (ipcPARAM == 12) or (ipcPARAM == 13) then
  SwiPos = ipc.readLvar("L:Duke_Tank_Selector_R")
-- Schalterposition nur innerhalb der Grenzen 0..2 verändern  
  if (ipcPARAM == 13) and (SwiPos < 100) then			-- ipcPARAM 10 : Left Fuel Selector clockwise
    NewSwiPos = SwiPos + 50
  elseif (ipcPARAM == 12) and (SwiPos > 0) then			-- ipcPARAM 11 : Left Fuel Selector counterclockwise
    NewSwiPos = SwiPos - 50
  else
    NewSwiPos = SwiPos
  end
  if NewSwiPos ~= SwiPos then
    ipc.writeLvar("L:Duke_Tank_Selector_R",NewSwiPos)
  end	
  return  
--  
-- alles andere keine gueltige Schalterstellung
--  
else
  ipc.lineDisplay("PARAM not implemented")
  ipc.sleep(3000)
end
