-- 23.04.17/AH Turbine Duke V2 Ignition Switches / Avionics Mstr / Autopilot
-- 11.05.18/AH erweitert auf TT statische Switche
-- Parm =  1 : Inverter on (Standby muss über VC selektiert werden)
-- Parm =  2 : Inverter off
-- Parm =  3 : Master Avionics on
-- Parm =  4 : Master Avionics off
-- Parm =  5 : AP Alt Arm
-- Parm =  6 : AP Yaw Damper
-- Parm = 10 : AP VS Incr
-- Parm = 11 : AP VS Decr
-- Parm = 12 : AP VS Display
-- Parm = 13 : AP FD
--
-- Parm 10/11 AP VS Incr/Decr aus 
--
--	http://forum.simflight.com/topic/69768-realair-beech-duke-turbine/
--	ipc.set("AvionicsMaster", 0/1) = Avionics Master
--	ipc.writeLvar(Inverter, 0/2/1) = Inverter 0=On/Main, 1=off, 2=Stby (!!!)
--  Script-Logik (Inv. on = Main oder Stdby !) :
--  Inv		Av.Mstr :
--  off		egal		-> Inv. On	
--  on		off			-> Av.Mstr On
--  egal	on			-> Both off

--
-- TT statische Switch
--
if ipcPARAM == 1 then
  ipc.writeLvar("L:Duke_Inverter_Switch", 0)		-- 0 = Inverter Main (2 = Standby)
  return
elseif ipcPARAM == 2 then
  ipc.writeLvar("L:Duke_Inverter_Switch", 1)		-- 1 = Inverter Off
  return
elseif ipcPARAM == 3 then
  ipc.writeUB(0x2E80, 1)							-- 1 = Avionics Master On
  return
elseif ipcPARAM == 4 then
  ipc.writeUB(0x2E80, 0)							-- 1 = Avionics Master Off
  return
--  
--  Non-Standard Autopilot Buttons
--
elseif ipcPARAM == 5 then							-- AP ARM (Altitude Arm)
  ArmButValue=ipc.readLvar("L:ApArmButAnt")					-- Get AP ARM Button State
  if ArmButValue == 0 then
    ipc.writeLvar("L:ApArmBut", 1)							-- AP Alt Arm Button on
    ApAltLock=ipc.writeUW(0x07D0,1)							-- x07D0 = AP Alt Lock on
  else
    ipc.writeLvar("L:ApArmBut", 0)							-- AP Alt Arm Button off
    ApAltLock=ipc.writeUW(0x07D0,0)							-- x07D0 = AP Alt Lock off
  end
  return
elseif ipcPARAM == 6 then							-- AP YAW DAMPER
  YdButValue=ipc.readLvar("L:ApYdButAnt")				-- Get AP YD Button State
  if YdButValue == 0 then
	ipc.writeLvar("ApYdBut",1)
    YawDamper=ipc.writeUD(0x0808,1)					-- Set Yaw Damper on
  else
    ipc.writeLvar("ApYdBut", 0)							-- AP YD Button on
    YawDamper=ipc.writeUD(0x0808,0)					-- Set Yaw Damper off
  end
  return
--
-- Increment Autopilot VS - and display VS
--  
elseif ipcPARAM == 10 then
  ipc.writeLvar("L:apVsUpBut",1)					-- Push AP VS Up Button
  ipc.control(65894)								-- Control for AP VS Increment
  abstime=ipc.readDBL(0x0230)						-- get FSX absolute time (seconds since 1.1.0000, double float)
  clicktime=abstime  								-- set click time to now
  ipc.writeLvar("L:VS_Click_Time",clicktime)		-- so the Ap show VS for ~3 seconds 
  ipc.writeLvar("L:Alt_VS_Display_Toggle",1)		-- Toggle Display
--
-- Decrement Autopilot VS - and display VS
--  
elseif ipcPARAM == 11 then
  ipc.writeLvar("L:apVsDnBut",1)					-- Push AP VS Down Button
  ipc.control(65895)								-- Control for AP VS Dencrement
  abstime=ipc.readDBL(0x0230)						-- get FSX absolute time (seconds since 1.1.0000, double float)
  clicktime=abstime  								-- set click time to now
  ipc.writeLvar("L:VS_Click_Time",clicktime)		-- so the Ap show VS for ~3 seconds 
  ipc.writeLvar("L:Alt_VS_Display_Toggle",1)		-- Toggle Display
--
-- Display Autopilot VS 
--  
elseif ipcPARAM == 12 then
  ipc.writeLvar("L:apVsBut",1)						-- Push AP VS Button
  abstime=ipc.readDBL(0x0230)						-- get FSX absolute time (seconds since 1.1.0000, double float)
  clicktime=abstime  								-- set click time to now
  ipc.writeLvar("L:VS_Click_Time",clicktime)		-- so the Ap show VS for ~3 seconds 
  ipc.writeLvar("L:Alt_VS_Display_Toggle",1)		-- Toggle Display
--
-- Autpilot Flight Director Toggle
--  
elseif ipcPARAM == 13 then
  FsxFDir=ipc.readUD(0x2EE0)						-- FSX state of Flight Director, 0=off, 1=on
  if FsxFDir > 0 then
    ipc.writeLvar("L:ApFdBut",1)					-- AP FD Button toggle (FSX-FD=0 -> FD-Button=1 & vice versa !)
    ipc.writeUD(0x2EE0,0)							-- Set FSX state of Flight Director to off
  else	
    ipc.writeLvar("L:ApFdBut",0)					-- AP FD Button on
    ipc.writeUD(0x2EE0,1)							-- Set FSX state of Flight Director to on
  end	
  return
--
-- Teil für Toggle-Switche  (Throttle Quadr)
--  
else
-- Inverter und Avionics Master Stellung holen
  InvPos = ipc.readLvar("L:Duke_Inverter_Switch")
  AvMPos = ipc.readUB(0x2E80)

--  ipc.lineDisplay("InvPos:"..InvPos.." AvMPos:"..AvMPos)


--
-- Inverter aus ?
--
  if ( InvPos == 1) then
-- dann Inverter ein (Main)
    InvPos = 0
    ipc.writeLvar("L:Duke_Inverter_Switch", InvPos)
--
-- Inverter Main/Stby, Avionics Master aus ?
--
  elseif ( InvPos ~= 1) and (AvMPos == 0 ) then
-- dann Avionics Master ein
    AvMPos = 1
    ipc.writeUB(0x2E80, AvMPos)
--
-- Inverter Main/Stby, Avionics Master ein ?
--
  elseif ( AvMPos == 1 ) then
-- dann Avionics Master und Inverter ein
    AvMPos = 0
    ipc.writeUB(0x2E80, AvMPos)
    InvPos = 1
    ipc.writeLvar("L:Duke_Inverter_Switch", InvPos)
  else
--  
-- alles andere keine gueltige Schalterstellung
--  
  end
end