-- Free / used memory monitor for FSX
-- by MarkH
--
-- REQUIRES
--
--        showvas.lua (this file)
--        hidevas.lua
-- 14.09.17/AH von https://www.avsim.com/forums/topic/488538-monitoring-vas-real-time-in-the-sim/
--			umbenanne in vasshow.lua und vashide.lua
--
--        Put these two files in your FSX/modules folder.
--
-- This displays a window showing the amount of memory currently in use by FSX and
-- the amount remaining. The window is removed by calling the complementary program
-- 'hidevas'.
--
-- The two programs will appear in the list of FSX functions available to be mapped to
-- keys in FSUIPC's 'buttons and switches' dialog. They will appear as 'Lua Showvas' and
-- 'Lua Hidevas' unless you have renamed the files. I suggest you map 'Lua Showvas' to
-- a button-down event and 'Lua Hidevas' to the corresponding button-up event, so the
-- display is only shown while you hold the button down.

local function Round(nVal)
    return math.floor(nVal + 0.5)
end

local MaxMem = 2^32 / 1024 -- Size of FSX virtual address space in kilobytes

ipc.setowndisplay("Mem Used / Remaining", 47.5, 0, 5, 2.5) -- Title, x, y, width and height (as % of display width and height).
ipc.set("VASWindow", 1) -- A global ipc variable we've invented to maintain the window state

-- Now we sit in a loop reading and displaying the values until our global
-- flag gets reset, typically by the button-up action.

local FreeMemOffset = 0x024C
repeat
    local FreeMem = ipc.readUD(FreeMemOffset)
    local UsedMem = MaxMem - FreeMem
    ipc.display(Round(UsedMem / 1000) .. " / " .. Round(FreeMem / 1000) .. " KB x 1000")
    ipc.sleep(200) -- Milliseconds
until ipc.get("VASWindow") == 0